﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class ConnectTest
    {
        private readonly string m_KeyString;
        private readonly HtcsCommunicator m_HtcsCommunicator;

        const int EchoDataSize = 1024;

        public ConnectTest(string keyString, HtcsCommunicator htcsCommunicator)
        {
            m_KeyString = keyString;
            m_HtcsCommunicator = htcsCommunicator;
        }

        public void Start()
        {
            for (int i = 0; i < 2; i++)
            {
                TargetServerTest();
                TargetClientTest();

                // echoServer のポート Close 中に次の echoClient がそのポートに接続を試行してしまうようなので少し待つ
                System.Threading.Thread.Sleep(100);
            }

            BacklogTest();
        }

        public void TargetServerTest()
        {
            TestClient echoClient = new TestClient("LongPortName12345678_" + m_KeyString, m_HtcsCommunicator, (client) => Utils.Echo(client, EchoDataSize, 10));
            echoClient.Start();
            echoClient.Wait();
        }

        public void TargetClientTest()
        {
            TestServer echoServer = new TestServer(0, "LongPeerName1234567890123456789", "LongPortName12345678_" + m_KeyString, m_HtcsCommunicator, (client) => Utils.Echo(client, EchoDataSize, 10));
            echoServer.Start();
            echoServer.Wait();
        }

        public void BacklogTest()
        {
            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "Echo_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }

            const int ClientCount = 11; // テストする backlog 数 + 1
            TcpClient[] client = new TcpClient[ClientCount];
            for (int i = 0; i < ClientCount; i++)
            {
                client[i] = new TcpClient();
                client[i].Connect(portMapItem.EndPoint);
                System.Threading.Thread.Sleep(100);
            }
            try
            {
                var tmpClient = new TcpClient();
                tmpClient.Connect(portMapItem.EndPoint);
            }
            catch (Exception e)
            {
                Console.WriteLine("Expected error");
                Console.WriteLine(e.Message);
            }
            for (int i = 0; i < ClientCount; i++)
            {
                Console.WriteLine("Echo ({0}/{1})", i + 1, ClientCount);
                Utils.Echo(client[i], EchoDataSize);
                client[i].Close();
            }
            {
                Console.WriteLine("Test after backlog count is 0");
                var tmpClient = new TcpClient();
                tmpClient.Connect(portMapItem.EndPoint);
                Console.WriteLine("Connected");
                Utils.Echo(tmpClient, EchoDataSize);
                tmpClient.Close();
            }
        }
    }
}
