﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <random>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/htclow/htclow_Result.h>
#include <nn/htclow/htclow_ResultPrivate.h>

#include "../../../../../Programs/Eris/Sources/Libraries/htclow/server/htclow_Packet.h"

#include "testHtclow_Util.h"

namespace nnt { namespace htclow {

void PrintResult(nn::Result result, const char* file, int line) NN_NOEXCEPT
{
    const char* name = "UnknownResult";

#define NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(_r) if (result <= _r()) { name = #_r; }
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultConnectionFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultBufferOverflow);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultUnknownDriverType);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelStateError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelClosed);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultInternalError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultOverflow);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultOutOfMemory);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultInvalidArgument);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultProtocolError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultCancelled);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultMuxError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelBufferOverflow);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelBufferHasNotEnoughData);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelVersionNotMatched);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelStateTransitionError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelReceiveBufferEmpty);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultChannelSequenceIdNotMatched);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultDriverError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultDriverOpened);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultDebugDriverError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketDriverError);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketAllocationFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketBindFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketConnectFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketListenFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketAcceptFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketReceiveFailure);
    NNT_DETAIL_HTCLOW_PRINT_RESULT_IF(nn::htclow::ResultSocketSendFailure);
#undef NNT_DETAIL_HTCLOW_PRINT_RESULT_IF

    NN_LOG("%s:%d %s (module:%d / description:%d)\n", file, line, name, result.GetModule(), result.GetDescription());
}

int16_t GetMaxVersion() NN_NOEXCEPT
{
    return nn::htclow::server::MaxVersion;
}

int GetMaxBodySize() NN_NOEXCEPT
{
    return nn::htclow::server::MaxBodySize;
}

std::unique_ptr<uint8_t[]> MakeRandomArray(int size, int seed) NN_NOEXCEPT
{
    auto buffer = std::make_unique<uint8_t[]>(size);

    std::mt19937 mt(seed);

    for (int i = 0; i < size; i++)
    {
        buffer[i] = static_cast<uint8_t>(mt());
    }

    return buffer;
}

std::unique_ptr<uint8_t[]> MakeZeroArray(int size) NN_NOEXCEPT
{
    auto buffer = std::make_unique<uint8_t[]>(size);

    std::memset(buffer.get(), 0, size);

    return buffer;
}

}}
