﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/htc.h>
#include <nn/htc/htc_Result.h>
#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

TEST(GetEnvrionmentVariable, GetLengthConnectionFailure)
{
    nn::htc::Initialize();

    const char EnvVarName[] = "NINTENDO_SDK_ROOT";
    size_t length;
    nn::Result result = nn::htc::GetEnvironmentVariableLength(&length, EnvVarName);
    NNT_EXPECT_RESULT_FAILURE(nn::htc::ResultConnectionFailure, result);

    nn::htc::Finalize();
}

TEST(GetEnviaronmentVariable, GetVariableConnectionFailure)
{
    nn::htc::Initialize();

    const char EnvVarName[] = "NINTENDO_SDK_ROOT";
    size_t length;
    const size_t bufferLength = 128;
    char buffer[bufferLength];
    nn::Result result = nn::htc::GetEnvironmentVariable(&length, buffer, bufferLength, EnvVarName);
    NNT_EXPECT_RESULT_FAILURE(nn::htc::ResultConnectionFailure, result);

    nn::htc::Finalize();

}
