﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

enum DrawMode
{
    DrawMode_1to2 = 0,
    DrawMode_3to4,
    DrawMode_5to6,
    DrawMode_7to8,
    DrawMode_Hh,
};

enum BusStatus
{
    HidbusState_NotGotHandle = 0,   // 初期状態
    HidbusState_GotHandle,          // ハンドル取得、初期化完了
    HidbusState_Enabled,            // デバイス有効
    HidbusState_Polling,            // PollingMode有効
    HidbusStateCount,
};

enum IsPolling
{
    IsPolling_Disable = 0,
    IsPolling_Enable,
};

struct HidbusState
{
    nn::hidbus::BusHandle handle;        //!< Hidbusハンドル
    BusStatus mode;                      //!< Hidbusのステータス
    IsPolling isPolling;                   //!< Polling中かどうか
    int PollingCount;                     //!< PollingModeで取得するcount値
    uint8_t command[4];                  //!< Hidbusコマンド
    uint32_t sendingCmd;                 //!< 現在SendAndReceive中のHidbusコマンド
    uint32_t PollingCmd;                  //!< 現在Polling中のHidbusコマンド
    uint8_t packet[16];                  //!< SendAndReceive受信パケット(データ部)
    uint8_t PollingPacket[16][16];        //!< Polling受信パケット(データ部)
    int64_t samplingNumber[16];          //!< サンプリングナンバー
    NN_ALIGNAS(nn::os::MemoryPageSize) char workBuffer[nn::os::MemoryPageSize * 2];   //!< ワークバッファ(PollingMode時に渡す)
    size_t  packetSize;                  //!< SendAndReceive受信パケット(データ部)のサイズ[Byte]
    size_t PollingPacketSize[16];         //!< Polling受信パケットサイズ[Byte]

};

const int PollingCountMax = 10;

struct RondeData
{
    uint8_t  uniqueId[PollingCountMax][nns::hidbus::RondeUniqueIdSize];      //!< ユニークID
    uint16_t fwVer[PollingCountMax];                                         //!< FWバージョン
    int64_t  samplingNumber[PollingCountMax];                                //!< サンプリングナンバー
    int16_t  strain[PollingCountMax];                                        //!< 歪ゲージ生値
    int16_t  thermistor[PollingCountMax];                                    //!< サーミスタ生値
    nns::hidbus::RondeManufactureCalibrationData  scal[PollingCountMax];     //!< 工程Cal
    nns::hidbus::RondeManufactureCalibrationData  ucal[PollingCountMax];     //!< ユーザーCal
};

namespace {
}
