﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"
#include "SixAxisSensorGestureProcessorTypes.h"

class SixAxisSensorGestureProcessor
{
    NN_DISALLOW_COPY(SixAxisSensorGestureProcessor);
    NN_DISALLOW_MOVE(SixAxisSensorGestureProcessor);

private:

    // ジェスチャ格納用 LIFO
    GestureStateLifo m_GestureStateLifo;
    GestureState m_GestureState;
    int64_t m_GestureSamplingNumber;
    int64_t m_ThresholdDeltaSamplingNumber;

    // MotionDetector 関連
    IMotionDetector* m_pMotionDetectors[MotionDetectorCountMax];

    // 重力計算用
    float m_GravityFilterConstant;

    // 入力データ
    SixAxisSensorRawState m_RawState;
    int64_t m_SamplingNumber;

public:
    SixAxisSensorGestureProcessor() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;

    void Update(const nn::hid::SixAxisSensorState& state) NN_NOEXCEPT;

    int GetGestures(GestureState* pOutStates, int count) NN_NOEXCEPT;

private:
    void Calculate(const nn::hid::SixAxisSensorState& state) NN_NOEXCEPT;

    void UpdateGestureLifo() NN_NOEXCEPT;

    void Append(const MotionState& state) NN_NOEXCEPT;

};
