﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/irsensor.h>

#include "Npad.h"

namespace frm {

    struct IrInfo
    {
        nn::irsensor::IrCameraHandle        handle;
        nn::irsensor::MomentProcessorConfig config;
        bool                                isInitialized = false;
        bool                                isRunning = false;
    };

    class IrSensor
    {

    private:
        IrInfo  m_Info[frm::NpadIdNum];

    public:
        //----------------------------------------------------------------
        // @brief   インスタンス取得
        //----------------------------------------------------------------
        static IrSensor& GetInstance() NN_NOEXCEPT;

        //----------------------------------------------------------------
        // @brief   Npadの初期化
        //----------------------------------------------------------------
        void Initialize(int index) NN_NOEXCEPT;

        //----------------------------------------------------------------
        // @brief   Npadの初期化
        //----------------------------------------------------------------
        void Finalize(int index) NN_NOEXCEPT;

        void SwitchStartAndStop(int index) NN_NOEXCEPT;

        //----------------------------------------------------------------
        // @brief   NPadの状態更新
        //----------------------------------------------------------------
        void Start(int index) NN_NOEXCEPT;

        //----------------------------------------------------------------
        // @brief   NPadの状態更新
        //----------------------------------------------------------------
        void Stop(int index) NN_NOEXCEPT;

    };
}

#ifndef gIrSensor
#define gIrSensor (frm::IrSensor::GetInstance())
#endif
