﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * ツールの選択状態を管理するだけの処理
 */

#include "CursolControl.h"

namespace frm {

    void Cursol::Top(ButtonSelect buttonSelect, frm::GestureState gestureState)
    {
        // Npadの選択か、Activityの選択かの切り替え
        if (buttonSelect.left == true || buttonSelect.right == true)
        {
            m_cursol.topForcus = m_cursol.topForcus == false ? true : false;
        }
        // Npadの選択
        if ((buttonSelect.up == true || gGesture.GetSwipe().Direction == nn::hid::GestureDirection_Down) && m_cursol.topForcus == false)
        {
            m_cursol.npadNo = m_cursol.npadNo == 0 ? 8 : m_cursol.npadNo - 1;
        }
        if ((buttonSelect.down == true || gGesture.GetSwipe().Direction == nn::hid::GestureDirection_Up) && m_cursol.topForcus == false)
        {
            m_cursol.npadNo = m_cursol.npadNo == 8 ? 0 : m_cursol.npadNo + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true || (gGesture.GetTouchTriggerInRange(350, 45, 240, 255) && m_cursol.topForcus == false))
        {
            // Npad選択時
            if (m_cursol.topForcus == false)
            {
                m_cursol.CursolStatus = CursolStatus_FixedNpad;
            }
            else
            {
                m_cursol.CursolStatus = CursolStatus_FixedActivity;
            }
        }
    }

    void Cursol::FixedActivity(ButtonSelect buttonSelect)
    {
        // SoundかRgbLedかの選択
        if (buttonSelect.up == true)
        {
            m_cursol.activity = m_cursol.activity == 0 ? 3 : m_cursol.activity - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.activity = m_cursol.activity == 3 ? 0 : m_cursol.activity + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            // Npad選択時
            if (m_cursol.activity == 0)
            {
                m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
            }
            else if(m_cursol.activity == 1)
            {
                m_cursol.CursolStatus = CursolStatus_FixedActivitySound;
            }
            else if (m_cursol.activity == 2)
            {
                m_cursol.CursolStatus = CursolStatus_FixedActivityRgbLed;
            }
            else if (m_cursol.activity == 3)
            {
                m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
            }
            else if (m_cursol.activity == 4)
            {
                m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
            }

            m_cursol.writeFunctionFixed = static_cast<WriteFunctionSelect>(m_cursol.activity);
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // TOPに戻る
            m_cursol.CursolStatus = CursolStatus_Top;
        }
    }

    void Cursol::FixedActivitySound(ButtonSelect buttonSelect, int cursolCount)
    {
        // Soundの選択
        if (buttonSelect.up == true)
        {
            m_cursol.sound = m_cursol.sound == 0 ? cursolCount - 1 : m_cursol.sound - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.sound = m_cursol.sound == cursolCount - 1 ? 0 : m_cursol.sound + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_WriteSound;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedActivity;
        }
    }

    void Cursol::WriteSound(ButtonSelect buttonSelect)
    {
        if (buttonSelect.up == true)
        {
            m_cursol.writePosition = m_cursol.writePosition == 0 ? 2 : m_cursol.writePosition - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.writePosition = m_cursol.writePosition == 2 ? 0 : m_cursol.writePosition + 1;
        }
        if (buttonSelect.left == true)
        {
            // 書き込むActivityIndexの指定
            if (m_cursol.writePosition == 0)
            {
                m_cursol.writeElement.npadIndex = m_cursol.writeElement.npadIndex == 0 ? 8 : m_cursol.writeElement.npadIndex - 1;
            }
            // soundIndexの指定
            if (m_cursol.writePosition == 1)
            {
                m_cursol.writeElement.Entry.waveIndex = m_cursol.writeElement.Entry.waveIndex == 0 ? SoundIndexMax + 9 : m_cursol.writeElement.Entry.waveIndex - 1;
            }
            // sound種類の指定
            else if (m_cursol.writePosition == 2)
            {
                switch (m_cursol.writeElement.Entry.waveSet)
                {
                    case nn::hid::PalmaWaveSet_Small:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Large;
                        break;

                    case nn::hid::PalmaWaveSet_Medium:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Small;
                        break;

                    case nn::hid::PalmaWaveSet_Large:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Medium;
                        break;

                    default:
                        break;
                }
            }
        }
        if (buttonSelect.right == true)
        {
            // 書き込むActivityIndexの指定
            if (m_cursol.writePosition == 0)
            {
                m_cursol.writeElement.npadIndex = m_cursol.writeElement.npadIndex == 8 ? 0 : m_cursol.writeElement.npadIndex + 1;
            }
            // soundIndexの指定
            if (m_cursol.writePosition == 1)
            {
                m_cursol.writeElement.Entry.waveIndex = m_cursol.writeElement.Entry.waveIndex == SoundIndexMax + 9 ? 0 : m_cursol.writeElement.Entry.waveIndex + 1;
            }
            // sound種類の指定
            else if (m_cursol.writePosition == 2)
            {
                switch (m_cursol.writeElement.Entry.waveSet)
                {
                    case nn::hid::PalmaWaveSet_Small:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Medium;
                        break;

                    case nn::hid::PalmaWaveSet_Medium:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Large;
                        break;

                    case nn::hid::PalmaWaveSet_Large:
                        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Small;
                        break;

                    default:
                        break;
                }
            }
        }
        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedActivitySound;
        }
    }

    void Cursol::FixedActivityRgbLed(ButtonSelect buttonSelect, int cursolCount)
    {
        // Ledの選択
        if (buttonSelect.up == true)
        {
            m_cursol.rgbLed = m_cursol.rgbLed == 0 ? cursolCount - 1 : m_cursol.rgbLed - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.rgbLed = m_cursol.rgbLed == cursolCount - 1 ? 0 : m_cursol.rgbLed + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_WriteRgbLed;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedActivity;
        }
    }

    void Cursol::WriteRgbLed(ButtonSelect buttonSelect)
    {
        if (m_cursol.writePosition >= 2)
        {
            m_cursol.writePosition = 0;
        }

        if (buttonSelect.up == true || buttonSelect.down == true)
        {
            m_cursol.writePosition = m_cursol.writePosition == 0 ? 1 : 0;
        }
        if (buttonSelect.left == true)
        {
            // 書き込むActivityIndexの指定
            if (m_cursol.writePosition == 0)
            {
                m_cursol.writeElement.npadIndex = m_cursol.writeElement.npadIndex == 0 ? 8 : m_cursol.writeElement.npadIndex - 1;
            }
            // RgbLedIndexの指定
            if (m_cursol.writePosition == 1)
            {
                m_cursol.writeElement.Entry.rgbLedPatternIndex = m_cursol.writeElement.Entry.rgbLedPatternIndex == 0 ?
                                                                 RgbLedIndexMax + 9 :
                                                                 m_cursol.writeElement.Entry.rgbLedPatternIndex - 1;
            }
        }
        if (buttonSelect.right == true)
        {
            // 書き込むActivityIndexの指定
            if (m_cursol.writePosition == 0)
            {
                m_cursol.writeElement.npadIndex = m_cursol.writeElement.npadIndex == 8 ? 0 : m_cursol.writeElement.npadIndex + 1;
            }
            // soundIndexの指定
            if (m_cursol.writePosition == 1)
            {
                m_cursol.writeElement.Entry.rgbLedPatternIndex = m_cursol.writeElement.Entry.rgbLedPatternIndex == RgbLedIndexMax + 9 ?
                                                                 0 :
                                                                 m_cursol.writeElement.Entry.rgbLedPatternIndex + 1;
            }
        }
        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedActivityRgbLed;
        }
    }

    void Cursol::FixedNpad(ButtonSelect buttonSelect, frm::GestureState gestureState)
    {
        // Npad機能選択
        if (buttonSelect.up == true || gGesture.GetSwipe().Direction == nn::hid::GestureDirection_Down)
        {
            m_cursol.npadFunction[m_cursol.npadNo] = m_cursol.npadFunction[m_cursol.npadNo] == 0 ? NpadMenuNum - 1 : m_cursol.npadFunction[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.down == true || gGesture.GetSwipe().Direction == nn::hid::GestureDirection_Up)
        {
            m_cursol.npadFunction[m_cursol.npadNo] = m_cursol.npadFunction[m_cursol.npadNo] == NpadMenuNum - 1 ? 0 : m_cursol.npadFunction[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true || gGesture.GetTouchTriggerInRange(350, 45, 240, 255))
        {
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = static_cast<NpadFunctionSelect>(m_cursol.npadFunction[m_cursol.npadNo]);
            m_cursol.CursolStatus = CursolStatus_FixedNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // TOPに戻る
            m_cursol.CursolStatus = CursolStatus_Top;
        }
    }

    void Cursol::FixedNpadFunction(ButtonSelect buttonSelect)
    {
        if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_StartScan)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadStartScan;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_WriteActivity)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadWriteActivity;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_PlayActivity)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadPlayActivity;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_CheckReserved)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadCheckReserved;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_SuspendFeatureSet)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadSuspendFeatureSet;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_ReadPlayLog)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadReadPlayLog;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_ResetPlayLog)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadResetPlayLog;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_ReadAppSection)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadReadAppSection;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_WriteAppSection)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadWriteAppSection;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_WriteDataBaseIdVer)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadWriteDataBaseIdVer;
        }
        else if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_SetFrModeType)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadSetFrModeType;
        }
        else
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }
    }

    void Cursol::FixedNpadStartScan(ButtonSelect buttonSelect)
    {
        if (buttonSelect.left == true || buttonSelect.right == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.scanDeviseType = m_cursol.scanDeviseType == 0 ? 1 : 0;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadSetFrModeType(ButtonSelect buttonSelect)
    {
        if (buttonSelect.left == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.frMode[m_cursol.npadNo] = m_cursol.frMode[m_cursol.npadNo] == 0 ? 4 : m_cursol.frMode[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.right == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.frMode[m_cursol.npadNo] = m_cursol.frMode[m_cursol.npadNo] == 4 ? 0 : m_cursol.frMode[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadSuspendFeatureSet(ButtonSelect buttonSelect)
    {
        if (buttonSelect.up == true)
        {
            m_cursol.featureSetPosition[m_cursol.npadNo] = m_cursol.featureSetPosition[m_cursol.npadNo] == 0 ? 3 : m_cursol.featureSetPosition[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.featureSetPosition[m_cursol.npadNo] = m_cursol.featureSetPosition[m_cursol.npadNo] == 3 ? 0 : m_cursol.featureSetPosition[m_cursol.npadNo] + 1;
        }
        if (buttonSelect.left == true || buttonSelect.right == true)
        {
            // FrModeの指定
            if (m_cursol.featureSetPosition[m_cursol.npadNo] == 0)
            {
                if (m_cursol.featureSet[m_cursol.npadNo].Test<nn::hid::PalmaFeature::FrMode>())
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::FrMode>(false);
                }
                else
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::FrMode>(true);
                }

            }
            // RumbleFeedBackの指定
            else if (m_cursol.featureSetPosition[m_cursol.npadNo] == 1)
            {
                if (m_cursol.featureSet[m_cursol.npadNo].Test<nn::hid::PalmaFeature::RumbleFeedback>())
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::RumbleFeedback>(false);
                }
                else
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::RumbleFeedback>(true);
                }
            }
            // Stepの指定
            else if (m_cursol.featureSetPosition[m_cursol.npadNo] == 2)
            {
                if (m_cursol.featureSet[m_cursol.npadNo].Test<nn::hid::PalmaFeature::Step>())
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::Step>(false);
                }
                else
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::Step>(true);
                }
            }
            // MuteSwitchの指定
            else if (m_cursol.featureSetPosition[m_cursol.npadNo] == 3)
            {
                if (m_cursol.featureSet[m_cursol.npadNo].Test<nn::hid::PalmaFeature::MuteSwitch>())
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::MuteSwitch>(false);
                }
                else
                {
                    m_cursol.featureSet[m_cursol.npadNo].Set<nn::hid::PalmaFeature::MuteSwitch>(true);
                }
            }
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    } // NOLINT(impl/function_size)

    void Cursol::FixedNpadWriteDataBaseIdVer(ButtonSelect buttonSelect)
    {
        if (buttonSelect.left == true)
        {
            m_cursol.dataBaseIdVer[m_cursol.npadNo] = m_cursol.dataBaseIdVer[m_cursol.npadNo] == 0 ? 255 : m_cursol.dataBaseIdVer[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.right == true)
        {
            m_cursol.dataBaseIdVer[m_cursol.npadNo] = m_cursol.dataBaseIdVer[m_cursol.npadNo] == 255 ? 0 : m_cursol.dataBaseIdVer[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadReadPlayLog(ButtonSelect buttonSelect)
    {
        // 読み込みサイズの指定
        if (buttonSelect.left == true)
        {
            m_cursol.playLogIndex[m_cursol.npadNo] = m_cursol.playLogIndex[m_cursol.npadNo] == 0 ?
                256 :
                m_cursol.playLogIndex[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.right == true)
        {
            m_cursol.playLogIndex[m_cursol.npadNo] = m_cursol.playLogIndex[m_cursol.npadNo] == 256 ?
                0 :
                m_cursol.playLogIndex[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadResetPlayLog(ButtonSelect buttonSelect)
    {
        // 読み込みサイズの指定
        if (buttonSelect.left == true)
        {
            m_cursol.playLogIndex[m_cursol.npadNo] = m_cursol.playLogIndex[m_cursol.npadNo] == 0 ?
                256 :
                m_cursol.playLogIndex[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.right == true)
        {
            m_cursol.playLogIndex[m_cursol.npadNo] = m_cursol.playLogIndex[m_cursol.npadNo] == 256 ?
                0 :
                m_cursol.playLogIndex[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadReadAppSection(ButtonSelect buttonSelect)
    {
        if (buttonSelect.up == true)
        {
            m_cursol.appSection[m_cursol.npadNo].position = m_cursol.appSection[m_cursol.npadNo].position == 0 ?
                                                                                2 :
                                                                                m_cursol.appSection[m_cursol.npadNo].position - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.appSection[m_cursol.npadNo].position = m_cursol.appSection[m_cursol.npadNo].position == 2 ?
                                                                                0 :
                                                                                m_cursol.appSection[m_cursol.npadNo].position + 1;
        }

        // 読み込みサイズの指定
        if (m_cursol.appSection[m_cursol.npadNo].position == 0)
        {
            if (buttonSelect.left == true)
            {
                m_cursol.appSection[m_cursol.npadNo].readSize = m_cursol.appSection[m_cursol.npadNo].readSize == 0 ?
                    AppSectionSizeMax + 9 :
                    m_cursol.appSection[m_cursol.npadNo].readSize - 1;
            }
            if (buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].readSize = m_cursol.appSection[m_cursol.npadNo].readSize == AppSectionSizeMax + 9 ?
                    0 :
                    m_cursol.appSection[m_cursol.npadNo].readSize + 1;
            }
        }
        // 読み込むアドレスの指定
        if (m_cursol.appSection[m_cursol.npadNo].position == 1)
        {
            if (buttonSelect.left == true)
            {
                m_cursol.appSection[m_cursol.npadNo].address = m_cursol.appSection[m_cursol.npadNo].address == 0 ?
                    4095 :
                    m_cursol.appSection[m_cursol.npadNo].address - 1;
            }
            if (buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].address = m_cursol.appSection[m_cursol.npadNo].address == 4095 ?
                    0 :
                    m_cursol.appSection[m_cursol.npadNo].address + 1;
            }
        }
        // 全領域読み込みの選択
        if (m_cursol.appSection[m_cursol.npadNo].position == 2)
        {
            if (buttonSelect.left == true || buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].isFull = m_cursol.appSection[m_cursol.npadNo].isFull == false ? true : false;
            }
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadWriteAppSection(ButtonSelect buttonSelect, int appSectionCount)
    {
        if (buttonSelect.up == true)
        {
            m_cursol.appSection[m_cursol.npadNo].position = m_cursol.appSection[m_cursol.npadNo].position == 0 ?
                                                                                        2 :
                                                                                        m_cursol.appSection[m_cursol.npadNo].position - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.appSection[m_cursol.npadNo].position = m_cursol.appSection[m_cursol.npadNo].position == 2 ?
                                                                                        0 :
                                                                                        m_cursol.appSection[m_cursol.npadNo].position + 1;
        }

        // 書き込みファイルの指定
        if (m_cursol.appSection[m_cursol.npadNo].position == 0)
        {
            if (buttonSelect.left == true)
            {
                m_cursol.appSection[m_cursol.npadNo].fileIndex = m_cursol.appSection[m_cursol.npadNo].fileIndex == 0 ?
                    appSectionCount - 1 :
                    m_cursol.appSection[m_cursol.npadNo].fileIndex - 1;
            }
            if (buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].fileIndex = m_cursol.appSection[m_cursol.npadNo].fileIndex == appSectionCount - 1 ?
                    0 :
                    m_cursol.appSection[m_cursol.npadNo].fileIndex + 1;
            }
        }
        // 書き込むアドレスの指定
        if (m_cursol.appSection[m_cursol.npadNo].position == 1)
        {
            if (buttonSelect.left == true)
            {
                m_cursol.appSection[m_cursol.npadNo].address = m_cursol.appSection[m_cursol.npadNo].address == 0 ?
                    4095 :
                    m_cursol.appSection[m_cursol.npadNo].address - 1;
            }
            if (buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].address = m_cursol.appSection[m_cursol.npadNo].address == 4095 ?
                    0 :
                    m_cursol.appSection[m_cursol.npadNo].address + 1;
            }
        }
        // 全領域読み込みの選択
        if (m_cursol.appSection[m_cursol.npadNo].position == 2)
        {
            if (buttonSelect.left == true || buttonSelect.right == true)
            {
                m_cursol.appSection[m_cursol.npadNo].isFull = m_cursol.appSection[m_cursol.npadNo].isFull == false ? true : false;
            }
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadSetBoostMode(ButtonSelect buttonSelect)
    {
        // 読み込みサイズの指定
        if (buttonSelect.left == true || buttonSelect.right == true)
        {
            m_cursol.isBoostMode[m_cursol.npadNo] = m_cursol.isBoostMode[m_cursol.npadNo] == false ? true : false;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadWriteActivity(ButtonSelect buttonSelect)
    {
        if (buttonSelect.up == true)
        {
            m_cursol.activityPosition[m_cursol.npadNo] = m_cursol.activityPosition[m_cursol.npadNo] == 0 ? 3 : m_cursol.activityPosition[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.down == true)
        {
            m_cursol.activityPosition[m_cursol.npadNo] = m_cursol.activityPosition[m_cursol.npadNo] == 3 ? 0 : m_cursol.activityPosition[m_cursol.npadNo] + 1;
        }
        if (buttonSelect.left == true)
        {
            // soundの指定
            if (m_cursol.activityPosition[m_cursol.npadNo] == 0)
            {
                m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex = m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex == 0 ?
                                                                            SoundIndexMax + 9 :
                                                                            m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex - 1;
            }
            // sound種類の指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 1)
            {
                switch (m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet)
                {
                    case nn::hid::PalmaWaveSet_Small:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Large;
                        break;

                    case nn::hid::PalmaWaveSet_Medium:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Small;
                        break;

                    case nn::hid::PalmaWaveSet_Large:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Medium;
                        break;

                    default:
                        break;
                }
            }
            // Ledの指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 2)
            {
                m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex = m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex == 0 ?
                                                                                     RgbLedIndexMax + 9 :
                                                                                     m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex - 1;
            }
            // 書き込むActivityIndexの指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 3)
            {
                m_cursol.activityElement[m_cursol.npadNo].Index = m_cursol.activityElement[m_cursol.npadNo].Index == 0 ?
                                                                  ActivityIndexMax + 9 :
                                                                  m_cursol.activityElement[m_cursol.npadNo].Index - 1;
            }
        }
        if (buttonSelect.right == true)
        {
            // soundの指定
            if (m_cursol.activityPosition[m_cursol.npadNo] == 0)
            {
                m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex = m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex == SoundIndexMax + 9 ?
                                                                            0 :
                                                                            m_cursol.activityElement[m_cursol.npadNo].Entry.waveIndex + 1;
            }
            // Ledの指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 2)
            {
                m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex = m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex == RgbLedIndexMax + 9 ?
                                                                                     0 :
                                                                                     m_cursol.activityElement[m_cursol.npadNo].Entry.rgbLedPatternIndex + 1;
            }
            // sound種類の指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 1)
            {
                switch (m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet)
                {
                    case nn::hid::PalmaWaveSet_Small:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Medium;
                        break;

                    case nn::hid::PalmaWaveSet_Medium:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Large;
                        break;

                    case nn::hid::PalmaWaveSet_Large:
                        m_cursol.activityElement[m_cursol.npadNo].Entry.waveSet = nn::hid::PalmaWaveSet_Small;
                        break;

                    default:
                        break;
                }
            }
            // 書き込むActivityIndexの指定
            else if (m_cursol.activityPosition[m_cursol.npadNo] == 3)
            {
                m_cursol.activityElement[m_cursol.npadNo].Index = m_cursol.activityElement[m_cursol.npadNo].Index == ActivityIndexMax + 9 ?
                                                                  0 :
                                                                  m_cursol.activityElement[m_cursol.npadNo].Index + 1;
            }
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    } // NOLINT(impl/function_size)

    void Cursol::FixedNpadPlayActivity(ButtonSelect buttonSelect)
    {
        if (buttonSelect.left == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.activityElement[m_cursol.npadNo].Index = m_cursol.activityElement[m_cursol.npadNo].Index == 0 ?
                                                              ActivityIndexMax + 9 :
                                                              m_cursol.activityElement[m_cursol.npadNo].Index - 1;
        }
        if (buttonSelect.right == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.activityElement[m_cursol.npadNo].Index = m_cursol.activityElement[m_cursol.npadNo].Index == ActivityIndexMax + 9 ?
                                                              0 :
                                                              m_cursol.activityElement[m_cursol.npadNo].Index + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::FixedNpadCheckReserved(ButtonSelect buttonSelect)
    {
        if (buttonSelect.left == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.reservedCheckIndex[m_cursol.npadNo] = m_cursol.reservedCheckIndex[m_cursol.npadNo] == 0 ? 2 :
                m_cursol.reservedCheckIndex[m_cursol.npadNo] - 1;
        }
        if (buttonSelect.right == true)
        {
            // 再生するActivityIndexの指定
            m_cursol.reservedCheckIndex[m_cursol.npadNo] = m_cursol.reservedCheckIndex[m_cursol.npadNo] == 2 ?
                0 :
                m_cursol.reservedCheckIndex[m_cursol.npadNo] + 1;
        }

        // 決定ボタン押下時の処理
        if (buttonSelect.fix == true)
        {
            m_cursol.CursolStatus = CursolStatus_DoNpadFunction;
        }

        // キャンセルボタン押下時の処理
        if (buttonSelect.cancel == true)
        {
            // 戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }
    }

    void Cursol::DoNpadFunction()
    {
        if (m_cursol.npadFunctionFixed[m_cursol.npadNo] == NpadFunctionSelect_PlayActivity)
        {
            m_cursol.CursolStatus = CursolStatus_FixedNpadPlayActivity;
        }
        else if(m_cursol.writeFunctionFixed != ActivityFunctionSelect_NoOperate)
        {
            m_cursol.writeFunctionFixed = ActivityFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedActivity;
        }
        else
        {
            // TOPに戻る
            m_cursol.npadFunctionFixed[m_cursol.npadNo] = NpadFunctionSelect_NoOperate;
            m_cursol.CursolStatus = CursolStatus_FixedNpad;
        }


    }

    /* ------------------------------------------------------------ */
     // PUBLIC関数
     /* ------------------------------------------------------------ */
    Cursol& Cursol::GetInstance()
    {
        static Cursol Instance;
        return Instance;
    }

    void Cursol::Initialize()
    {
        m_cursol.topForcus = false;
        m_cursol.npadNo = 8;
        m_cursol.activity = 0;
        m_cursol.sound = 0;
        m_cursol.rgbLed = 0;
        m_cursol.CursolStatus = CursolStatus_Top;

        m_cursol.writeFunctionFixed = ActivityFunctionSelect_NoOperate;
        m_cursol.writeElement.npadIndex = 0;
        m_cursol.writeElement.Entry.rgbLedPatternIndex = 0;
        m_cursol.writeElement.Entry.waveIndex = 0;
        m_cursol.writeElement.Entry.waveSet = nn::hid::PalmaWaveSet_Small;

        for (auto index = 0; index < frm::NpadIdNum; index++)
        {
            m_cursol.npadFunction[index] = 0;
            m_cursol.npadFunctionFixed[index] = NpadFunctionSelect_NoOperate;
            m_cursol.activityElement[index].Entry.rgbLedPatternIndex = 0;
            m_cursol.activityElement[index].Entry.waveIndex = 0;
            m_cursol.activityElement[index].Entry.waveSet = nn::hid::PalmaWaveSet_Small;
            m_cursol.activityElement[index].Index = 0;
        }
    }

    void Cursol::Update(frm::NpadState* npadState, frm::GestureState gestureState, int waveCursolCount, int rgbLedCursolCount, int appSectionCount)
    {
        ButtonSelect select;

        select.up = false;
        select.down = false;
        select.left = false;
        select.right = false;
        select.fix = false;
        select.cancel = false;

        for (auto index = 0; index < frm::NpadIdNum; index++)
        {
            // 選択
            if (npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickLUp>()
             || npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickRUp>()
             || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickLUp>()
             || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickRUp>())
            {
                select.up = true;
            }
            if (npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickLDown>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickRDown>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickLDown>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickRDown>())
            {
                select.down = true;
            }
            if (npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickLLeft>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickRLeft>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickLLeft>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickRLeft>())
            {
                select.left = true;
            }
            if (npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickLRight>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickRRight>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickLRight>()
                || npadState[index].longPress.Test<nn::hid::NpadJoyButton::StickRRight>())
            {
                select.right = true;
            }
            // 決定
            if (npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickL>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::StickR>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::L>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::R>())
            {
                select.fix = true;
            }
            // キャンセル(
            if (npadState[index].trigger.Test<nn::hid::NpadPalmaButton::Palma>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::ZL>()
                || npadState[index].trigger.Test<nn::hid::NpadJoyButton::ZR>())
            {
                select.cancel = true;
            }
        }


        switch (m_cursol.CursolStatus)
        {
            case CursolStatus_Top:
                Top(select, gestureState);
                break;

            case CursolStatus_FixedNpad:
                FixedNpad(select, gestureState);
                break;

            case CursolStatus_FixedActivity:
                FixedActivity(select);
                break;

            case CursolStatus_FixedNpadFunction:
                FixedNpadFunction(select);
                break;

            case CursolStatus_FixedNpadStartScan:
                FixedNpadStartScan(select);
                break;

            case CursolStatus_FixedNpadWriteActivity:
                FixedNpadWriteActivity(select);
                break;

            case CursolStatus_FixedNpadPlayActivity:
                FixedNpadPlayActivity(select);
                break;

            case CursolStatus_FixedNpadCheckReserved:
                FixedNpadCheckReserved(select);
                break;

            case  CursolStatus_FixedNpadReadPlayLog:
                FixedNpadReadPlayLog(select);
                break;

            case  CursolStatus_FixedNpadResetPlayLog:
                FixedNpadResetPlayLog(select);
                break;

            case  CursolStatus_FixedNpadReadAppSection:
                FixedNpadReadAppSection(select);
                break;

            case  CursolStatus_FixedNpadWriteAppSection:
                FixedNpadWriteAppSection(select, appSectionCount);
                break;

            case  CursolStatus_FixedNpadWriteDataBaseIdVer:
                FixedNpadWriteDataBaseIdVer(select);
                break;

            case CursolStatus_FixedNpadSetFrModeType:
                FixedNpadSetFrModeType(select);
                break;

            case CursolStatus_FixedNpadSuspendFeatureSet:
                FixedNpadSuspendFeatureSet(select);
                break;

            case CursolStatus_FixedNpadSetBoostMode:
                FixedNpadSetBoostMode(select);
                break;

            case CursolStatus_FixedActivitySound:
                FixedActivitySound(select, waveCursolCount);
                break;

            case CursolStatus_FixedActivityRgbLed:
                FixedActivityRgbLed(select, rgbLedCursolCount);
                break;

            case CursolStatus_WriteSound:
                WriteSound(select);
                break;

            case CursolStatus_WriteRgbLed:
                WriteRgbLed(select);
                break;

            case CursolStatus_DoNpadFunction:
                DoNpadFunction();
                break;

            default:
                break;
        }
    } // NOLINT(impl/function_size)

    CursolPosition Cursol::GetCursol()
    {
        return m_cursol;
    }
}
