﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "LogPrint.h"
#include "SceneLog.h"
#include "ScreenStatics.h"
#include "ScreenUtil.h"
#include "s2d/Simple2D.h"

void SceneLog::DrawImpl(RecordablePosition& position) NN_NOEXCEPT
{
    const auto& logs = GetLogs();

    for (auto it = logs.begin();
        it != logs.end();
        ++it)
    {
        position.x = PositionSceneText.x;
        if ((*it).isWarn)
        {
            s2d::SetTextColor(ColorSceneTextStrong02);
        }
        else
        {
            s2d::SetTextColor(ColorSceneTextDefault);
        }
        s2d::DrawText(position.Get(), "[%04d/%02d/%02d %02d:%02d:%02d] %s",
            (*it).time.year, (*it).time.month, (*it).time.day, (*it).time.hour, (*it).time.minute, (*it).time.second,
            (*it).log);
        position.y += YSizeLine;
    }
}
