﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/util/util_MathTypes.h>

#include "s2d/Simple2D.h"

class IPacketChartDataSetAccessor
{
protected:
    std::string m_Label;
    s2d::Color m_Color;

public:
    virtual int size() NN_NOEXCEPT = 0;
    virtual bool at(int index) NN_NOEXCEPT = 0;
    virtual const char* continuousDrop(char* buf) NN_NOEXCEPT = 0;
    virtual const char* maxDrop(char* buf) NN_NOEXCEPT = 0;
    s2d::Color color() NN_NOEXCEPT
    {
        return m_Color;
    }
    const char* label() NN_NOEXCEPT
    {
        return m_Label.c_str();
    }
};

class PacketChart
{
private:
    int          m_SampleCountMax;  // 表示するサンプル数

public:
    void Draw(int sampleCount,
              s2d::Point2D position,
              s2d::Size    size,
              IPacketChartDataSetAccessor* pDataSets) NN_NOEXCEPT;


private:
    void DrawFrame(s2d::Point2D position,
                   s2d::Size    size) NN_NOEXCEPT;
    void DrawSamples(s2d::Point2D position,
                     s2d::Size    size,
                     IPacketChartDataSetAccessor* pDataSets) NN_NOEXCEPT;
    void DrawValue(s2d::Point2D position,
                   s2d::Size    size,
                   IPacketChartDataSetAccessor* pDataSets) NN_NOEXCEPT;
};
