﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/hid/hid_NpadCommonTypes.h>

const nn::hid::NpadIdType NpadIds[] = {nn::hid::NpadId::Handheld,
                                       nn::hid::NpadId::No1,
                                       nn::hid::NpadId::No2,
                                       nn::hid::NpadId::No3,
                                       nn::hid::NpadId::No4,
                                       nn::hid::NpadId::No5,
                                       nn::hid::NpadId::No6,
                                       nn::hid::NpadId::No7,
                                       nn::hid::NpadId::No8,
                                       };
const int NpadIdCountMax = sizeof(NpadIds) / sizeof(nn::hid::NpadIdType);

inline std::string GetNpadIdString(const nn::hid::NpadIdType& id)
{
    switch (id)
    {
    case nn::hid::NpadId::Handheld:
        return "NpadId_Handheld";
    case nn::hid::NpadId::No1:
        return "NpadId_No1";
    case nn::hid::NpadId::No2:
        return "NpadId_No2";
    case nn::hid::NpadId::No3:
        return "NpadId_No3";
    case nn::hid::NpadId::No4:
        return "NpadId_No4";
    case nn::hid::NpadId::No5:
        return "NpadId_No5";
    case nn::hid::NpadId::No6:
        return "NpadId_No6";
    case nn::hid::NpadId::No7:
        return "NpadId_No7";
    case nn::hid::NpadId::No8:
        return "NpadId_No8";
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}
