﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @brief
*  nn::hid ライブラリのジェスチャ API の使い方を示すサンプルプログラム
*/

#pragma once

#include <cstdlib>
#include <list>
#include <vector>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid/hid_Gesture.h>
#include <nn/TargetConfigs/build_Platform.h>
#include <nn/util/util_Constant.h>
#include <nn/util/util_MathTypes.h>
#include <nn/util/util_Matrix.h>

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
#include <nv/nv_MemoryManagement.h>
#endif

#include "AppHeap.h"
#include "GraphicsSys.h"
#include "FontSys.h"
#include "Color.h"

namespace frm{
namespace hid{

    struct TapState
    {
        bool btn;           // 現在のボタン押下状態
        bool btnOld;        // 前回のボタン押下状態
        bool trgOffOn;      // ボタン押下状態がOFFからONに切り替わったことを示す
        bool trgOnOff;      // ボタン押下状態がONからOFFに切り替わったことを示す
    };

    class TouchScreen
    {
    private:
        std::list<nn::hid::GestureState> m_Events;
        std::vector<nn::hid::GesturePoint> m_Points;
        float m_Scale;
        float m_Angle;

        int64_t m_EventNumber;
        nn::hid::GestureState* m_States;

    public:
        static TouchScreen& GetInstance() NN_NOEXCEPT;

        TouchScreen() NN_NOEXCEPT
            : m_Scale(1)
            , m_Angle(0)
            , m_EventNumber(-1)
        {
            m_States = new nn::hid::GestureState[nn::hid::GestureStateCountMax]();
        }

        ~TouchScreen() NN_NOEXCEPT
        {
            delete[] m_States;
        }

        void Initialize() NN_NOEXCEPT;

        const std::list<nn::hid::GestureState>& GetEvents() const NN_NOEXCEPT;

        const std::vector<nn::hid::GesturePoint>& GetPoints() const NN_NOEXCEPT;

        float GetScale() NN_NOEXCEPT;

        float GetAngle() NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;

        void Precess(const nn::hid::GestureState& state) NN_NOEXCEPT;

        void WriteCursor(nn::gfx::util::DebugFontTextWriter* pTextWriter, int32_t x, int32_t y) NN_NOEXCEPT;

        void WritePoints(nn::gfx::util::DebugFontTextWriter* pTextWriter, const std::vector<nn::hid::GesturePoint>& points) NN_NOEXCEPT;

        const char* GetGestureDirection(nn::hid::GestureDirection direction) NN_NOEXCEPT;

        int CalRelativeAxis(nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;

        void makeTouchButton(nn::gfx::util::DebugFontTextWriter* pTextWriter, GraphicsSystem* pGraphicsSystem, const char* title, TapState* t_St, float orgX, float orgY, float width, float height) NN_NOEXCEPT;

        void makeTouchButtonFrame(GraphicsSystem* pGraphicsSystem, float orgX, float orgY, float width, float height) NN_NOEXCEPT;

    private:
    };

}
}

#ifndef gTouchScreen
#define gTouchScreen (frm::hid::TouchScreen::GetInstance())
#endif
