﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>

#include <nn/oe.h>

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadHandheld.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadFullKey.h>

namespace frm {
namespace hid {

    //!< NPadの状態をひとまとめにした構造体定義
    struct NPadState
    {
        int64_t smpl;                       //!< サンプリングカウンタ
        nn::hid::NpadButtonSet btn;         //!< ボタンの現在押されている状態
        nn::hid::NpadButtonSet btnOld;      //!< ボタンが押されていた過去(1フレーム前)の状態
        nn::hid::NpadButtonSet trg;         //!< 現在のボタンのトリガ入力(押されたとき一発だけ立つ)
        nn::hid::NpadButtonSet longpress;   //!< 現在のボタンが長押しされた時に一発だけ立つ
        nn::hid::NpadButtonSet beat;        //!< 現在のボタンが長押しされた場合、周期的に立つ(長押しによるカーソル移動等に利用)
        nn::hid::AnalogStickState anlgL;    //!< Lアナログスティックのアナログ値
        nn::hid::AnalogStickState anlgR;    //!< Rアナログスティックのアナログ値
    };

    // サポートするNpadのID
    const nn::hid::NpadIdType NpadIds[] = { nn::hid::NpadId::No1,         //!< [0]：コントローラ番号1
                                            nn::hid::NpadId::No2,         //!< [1]：コントローラ番号2
                                            nn::hid::NpadId::No3,         //!< [2]：コントローラ番号3
                                            nn::hid::NpadId::No4,         //!< [3]：コントローラ番号4
                                            nn::hid::NpadId::No5,         //!< [4]：コントローラ番号5
                                            nn::hid::NpadId::No6,         //!< [5]：コントローラ番号6
                                            nn::hid::NpadId::No7,         //!< [6]：コントローラ番号7
                                            nn::hid::NpadId::No8,         //!< [7]：コントローラ番号8
                                            nn::hid::NpadId::Handheld,    //!< [8]：携帯モード
    };
    // サポートするNpadの数
    const int NpadIdCountMax = sizeof(NpadIds) / sizeof(nn::hid::NpadIdType);

    class Npad
    {
    private:

        //!< 現在のボタン状態を取得します
        void GetBtnState(NPadState* st) NN_NOEXCEPT;
        //!< 現在のボタントリガを取得します
        nn::hid::NpadButtonSet GetBtnTrg(const nn::hid::NpadButtonSet current,
                                         const nn::hid::NpadButtonSet previous) NN_NOEXCEPT;

        nn::hid::NpadButtonSet GetBtnLongPress(const nn::hid::NpadButtonSet current) NN_NOEXCEPT;
        nn::hid::NpadButtonSet GetBtnBeat(const nn::hid::NpadButtonSet current) NN_NOEXCEPT;

    public:
        static Npad& GetInstance() NN_NOEXCEPT;

        //!< NPadの初期化を行います
        void Initialize() NN_NOEXCEPT;
        //!< NPadの状態を取得します
        void Update(NPadState* st) NN_NOEXCEPT;
        //!< Npadの開く地ベー諸んを切り替えます
        int ChangeActivationMode(int md) NN_NOEXCEPT;
    };
}
}

#ifndef gNPad
#define gNPad (frm::hid::Npad::GetInstance())
#endif
