﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/hid.h>
#include <nn/hid/hid_ControllerSupport.h>
#include <nn/hid/hid_ResultControllerSupport.h>
#include <nn/hid/hid_NpadJoyCommon.h>

#include <nn/account.h>

namespace frm {
namespace hid {

    // スレッド状態をGETするAPIが存在しない為、例外的にexternする
    extern nn::os::ThreadType thred;

    //!< ConsoleSixAxisSensor 向けの処理を記述したクラスです。
    class Applet
    {

    private:
        bool f_enbl = false;

    public:
        static Applet& GetInstance() NN_NOEXCEPT;

        void Initialize();

        void CtlrSupThred();
        void AcntMngThred();

        void ThredDestroy();

        void CtlrSupNonThred();
        void AcntMngNonThred();

    };

    void CtlrSup(void* dummy);
    void AcntMng(void* dummy);
}
}

#ifndef gApplet
#define gApplet (frm::hid::Applet::GetInstance())
#endif
