﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "frm_Applet.h"

/* アプレットは全てメインスレッドとは別のスレッドで動作させてください */
namespace frm {
namespace hid {

    const size_t ThreadStackSize = 1024 * 8;
    NN_OS_ALIGNAS_THREAD_STACK char thredStack[ThreadStackSize];   // スレッドのスタック
    nn::os::ThreadType thred;
    void* dummy;

    /* Singleton パターン */
    Applet& Applet::GetInstance() NN_NOEXCEPT
    {
        static Applet Instance;
        return Instance;
    }

    /* ------------------------------------------------------------ */
    // PRIVATE関数
    /* ------------------------------------------------------------ */

    /* ------------------------------------------------------------ */
    // PUBLIC関数
    /* ------------------------------------------------------------ */
    void Applet::Initialize()
    {
        // アカウントライブラリの初期化
        nn::account::Initialize();
    }

    // コントローラサポートアプレット
    void Applet::CtlrSupThred()
    {
        if (f_enbl == false)
        {
            nn::os::CreateThread(&thred, CtlrSup, dummy, thredStack, ThreadStackSize, 1);
            nn::os::StartThread(&thred);
            f_enbl = true;
        }

    }

    // アカウント選択アプレット
    void Applet::AcntMngThred()
    {
        if (f_enbl == false)
        {
            nn::os::CreateThread(&thred, AcntMng, dummy, thredStack, ThreadStackSize, 1);
            nn::os::StartThread(&thred);
            f_enbl = true;
        }
    }

    // スレッドの削除
    void Applet::ThredDestroy()
    {
        if (thred._state == thred.State_Exited)
        {
            nn::os::DestroyThread(&thred);
            f_enbl = false;
        }
    }

    // コントローラサポートアプレット(スレッド起動なし)
    void Applet::CtlrSupNonThred()
    {
        void* dummy = (nullptr);
        CtlrSup(dummy);
    }

    // アカウント選択アプレット(スレッド起動なし)
    void Applet::AcntMngNonThred()
    {
        void* dummy = (nullptr);
        AcntMng(dummy);
    }

    /* ------------------------------------------------------------ */
    // クラス外関数
    /* ------------------------------------------------------------ */
     void CtlrSup(void* dummy)
    {
        if(!dummy)
        {
            nn::hid::ControllerSupportResultInfo result;
            nn::hid::ControllerSupportArg ctrlArg;
            ctrlArg.SetDefault();
            ctrlArg.enableIdentificationColor = true;
            nn::hid::SetNpadJoyHoldType(nn::hid::NpadJoyHoldType_Horizontal);

            nn::hid::ShowControllerSupport(&result, ctrlArg);
        }

    }

    void AcntMng(void* dummy)
    {
        if (!dummy)
        {
            nn::account::Uid uid;
            nn::account::ShowUserSelector(&uid);
        }
    }
}
}
// [EOF]
