﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "CommandHandler.h"

CommandHandler::CommandHandler() NN_NOEXCEPT
    : m_TestId()
    , m_pSampler(nullptr)
    , m_pLogger(nullptr)
{
    // 何もしない
}


void CommandHandler::SetConsoleSixAxisSensorSampler(ConsoleSixAxisSensorSampler* pSampler) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pSampler);
    m_pSampler = pSampler;
}

void CommandHandler::SetSixAxisSensorLogger(SixAxisSensorLogger* pLogger) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pLogger);
    m_pLogger = pLogger;
}

void CommandHandler::Update(const nn::hid::NpadButtonSet& buttons) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(m_pSampler);
    NN_ASSERT_NOT_NULL(m_pLogger);

    if (buttons.Test<nn::hid::NpadButton::Right>() ||
        buttons.Test<nn::hid::NpadButton::A>())
    {
        m_TestId.Next();
    }
    else if (buttons.Test<nn::hid::NpadButton::Left>() ||
        buttons.Test<nn::hid::NpadButton::Y>())
    {
        m_TestId.Prev();
    }
    else if (buttons.Test<nn::hid::NpadButton::Up>() ||
        buttons.Test<nn::hid::NpadButton::X>())
    {
        if (m_pSampler->IsSamplingStarted())
        {
            return;
        }

        m_pSampler->StartSampling();
        m_pLogger->SetTick(::nn::os::GetSystemTick());
        m_pLogger->AppendLineFormat();
    }
    else if (buttons.Test<nn::hid::NpadButton::Down>() ||
        buttons.Test<nn::hid::NpadButton::B>())
    {
        if (!m_pSampler->IsSamplingStarted())
        {
            return;
        }

        m_pSampler->StopSampling();
    }
}

int CommandHandler::GetTestId() const NN_NOEXCEPT
{
    return m_TestId.id;
}

