﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/hid/hid_Vibration.h>

namespace {

    const ::nn::hid::VibrationValue VibrationValueArray[] = {
        ::nn::hid::VibrationValue::Make(1.0000f, 160.00f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.9333f, 160.00f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.8667f, 160.00f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.8000f, 160.00f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 113.14f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 134.54f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 190.27f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 226.27f, 0.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 160.00f, 1.0000f, 160.00f),
        ::nn::hid::VibrationValue::Make(0.5000f, 160.00f, 0.5000f, 320.00f),
        ::nn::hid::VibrationValue::Make(1.0000f, 160.00f, 0.1000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 1.0000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 0.9333f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 0.8667f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 0.8000f, 320.00f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 1.0000f, 226.27f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 1.0000f, 269.09f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 1.0000f, 380.55f),
        ::nn::hid::VibrationValue::Make(0.0000f, 160.00f, 1.0000f, 452.55f)
    };

    void CheckVibrationValue(const nn::hid::VibrationValue* pSrc, const nn::hid::VibrationValue* pDst)
    {
        EXPECT_FLOAT_EQ(pSrc->amplitudeHigh, pDst->amplitudeHigh);
        EXPECT_FLOAT_EQ(pSrc->amplitudeLow,  pDst->amplitudeLow);
        EXPECT_FLOAT_EQ(pSrc->frequencyHigh, pDst->frequencyHigh);
        EXPECT_FLOAT_EQ(pSrc->frequencyLow,  pDst->frequencyLow);
    }
}

//!< VibrationWriterに関するテスト（正常系）
TEST(VibrationWriterSuite, NormalTest1)
{
    nn::hid::VibrationWriter writer;
    nn::hid::VibrationMixer target;
    nn::hid::VibrationNodeConnection connection;

    EXPECT_EQ(connection.Connect(&writer, &target), true);

    //Writerに入力した振動値が正しくMixerから取り出せるかの確認
    for (auto src : VibrationValueArray)
    {
        writer.Write(src);
        nn::hid::VibrationNode::Update();
        nn::hid::VibrationValue dst = target.GetCurrentVibration();
        CheckVibrationValue(&src, &dst);
    }
}
