﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

//!< ポリシー設定時の動作のチェック
TEST(NpadSystemCommonPolicy, CheckPolicy)
{
    // Npad が無効 Death が期待される
    for (auto& npadId : ::testhid::NpadIdsMinimalSet)
    {
        SCOPED_TRACE("Pre testing");
        ::testhid::ExpectDeathGetNpadState(npadId, nn::hid::NpadStyleFullKey::Mask);
    }

    nn::hid::InitializeNpad();

    nn::hid::system::ApplyNpadSystemCommonPolicy();

    auto style = nn::hid::GetSupportedNpadStyleSet();
    auto expectedStyle = ::testhid::GetSupportedNpadStyleMask() ^ nn::hid::NpadStyleGc::Mask;
    EXPECT_EQ(expectedStyle, style);

    // 本体機能ポリシーが有効になるとすべての Npad の状態を取得することが可能
    for (auto& npadId : ::testhid::NpadIds)
    {
        SCOPED_TRACE("No input Test");
        ::testhid::ExpectNoInputGetNpadState(npadId, nn::hid::NpadStyleFullKey::Mask);
    }

    nn::hid::debug::FinalizeNpad();

    // Npad が無効 Death が期待される
    for (auto& npadId : ::testhid::NpadIdsMinimalSet)
    {
        SCOPED_TRACE("Post testing");
        ::testhid::ExpectDeathGetNpadState(npadId, nn::hid::NpadStyleFullKey::Mask);
    }

    nn::hid::InitializeNpad();
    // 縦持ちに戻す
    nn::hid::SetNpadJoyHoldType(nn::hid::NpadJoyHoldType_Vertical);

    auto holdType = nn::hid::GetNpadJoyHoldType();
    EXPECT_EQ(nn::hid::NpadJoyHoldType_Vertical, holdType);

    nn::hid::debug::FinalizeNpad();
}

