﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

//!< 起動時のデフォルト設定値の確認
TEST(NpadHandheldActivationMode, DefaultNpadHandheldActivationMode)
{
    ::testhid::EnableIdAll();

    // デフォルトは Dual
    EXPECT_EQ(::nn::hid::GetNpadHandheldActivationMode(), ::nn::hid::NpadHandheldActivationMode_Dual);

    ::testhid::DisableIdAll();
}

//!< 設定値変更の確認
TEST(NpadHandheldActivationMode, ChangeNpadHandheldActivationMode)
{
    ::testhid::EnableIdAll();

    ::nn::hid::SetNpadHandheldActivationMode(::nn::hid::NpadHandheldActivationMode_None);
    EXPECT_EQ(::nn::hid::GetNpadHandheldActivationMode(), ::nn::hid::NpadHandheldActivationMode_None);

    ::nn::hid::SetNpadHandheldActivationMode(::nn::hid::NpadHandheldActivationMode_Single);
    EXPECT_EQ(::nn::hid::GetNpadHandheldActivationMode(), ::nn::hid::NpadHandheldActivationMode_Single);

    ::nn::hid::SetNpadHandheldActivationMode(::nn::hid::NpadHandheldActivationMode_Dual);
    EXPECT_EQ(::nn::hid::GetNpadHandheldActivationMode(), ::nn::hid::NpadHandheldActivationMode_Dual);

    ::testhid::DisableIdAll();
}

