﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/debug/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>
#include <nnt/nntest.h>

#include "../Common/testHid_Keyboard.h"

namespace {

class KeyboardLockKeyEventSuite : public ::testing::Test
{
protected:
    KeyboardLockKeyEventSuite() NN_NOEXCEPT
    {
        // 何もしない
    }

    virtual ~KeyboardLockKeyEventSuite() NN_NOEXCEPT NN_OVERRIDE
    {
        // 何もしない
    }

    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
    {
        ::nn::hid::InitializeKeyboard();

        ::nn::hid::system::SendKeyboardLockKeyEvent(
            ::nn::hid::system::KeyboardLockKeyEvent::NumLockOff::Mask |
            ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOff::Mask |
            ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOff::Mask);

        this->WaitAWhile();
    }

    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
    {
        ::nn::hid::system::SendKeyboardLockKeyEvent(
            ::nn::hid::system::KeyboardLockKeyEvent::NumLockOn::Mask |
            ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOff::Mask |
            ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOff::Mask);

        ::nn::hid::debug::FinalizeKeyboard();
    }

    void WaitAWhile() NN_NOEXCEPT
    {
        ::nn::os::SleepThread(
            ::nn::TimeSpan::FromMilliSeconds(
                ::nn::hid::KeyboardStateCountMax / 2 *
                ::nnt::hid::GetKeyboardSamplingInterval().GetMilliSeconds()));
    }
};

} // namespace

TEST_F(KeyboardLockKeyEventSuite, NumLockTest1)
{
    ::nn::hid::KeyboardState state = {};

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::NumLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());
}

TEST_F(KeyboardLockKeyEventSuite, CapsLockTest1)
{
    ::nn::hid::KeyboardState state = {};

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::CapsLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());
}

TEST_F(KeyboardLockKeyEventSuite, ScrollLockTest1)
{
    ::nn::hid::KeyboardState state = {};

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOn::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockToggle::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_TRUE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());

    ::nn::hid::system::SendKeyboardLockKeyEvent(
        ::nn::hid::system::KeyboardLockKeyEvent::ScrollLockOff::Mask);

    this->WaitAWhile();

    ::nn::hid::GetKeyboardState(&state);

    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::CapsLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::ScrollLock>());
    EXPECT_FALSE(
        state.modifiers.Test<::nn::hid::KeyboardModifier::NumLock>());
}
