﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_Keyboard.h>
#include <nnt/nntest.h>

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest001)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::A::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::A::Mask.Test(0x04));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest002)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::B::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::B::Mask.Test(0x05));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest003)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::C::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::C::Mask.Test(0x06));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest004)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D::Mask.Test(0x07));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest005)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::E::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::E::Mask.Test(0x08));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest006)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F::Mask.Test(0x09));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest007)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::G::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::G::Mask.Test(0x0A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest008)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::H::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::H::Mask.Test(0x0B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest009)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::I::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::I::Mask.Test(0x0C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest010)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::J::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::J::Mask.Test(0x0D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest011)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::K::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::K::Mask.Test(0x0E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest012)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::L::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::L::Mask.Test(0x0F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest013)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::M::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::M::Mask.Test(0x10));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest014)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::N::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::N::Mask.Test(0x11));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest015)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::O::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::O::Mask.Test(0x12));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest016)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::P::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::P::Mask.Test(0x13));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest017)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Q::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Q::Mask.Test(0x14));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest018)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::R::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::R::Mask.Test(0x15));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest019)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::S::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::S::Mask.Test(0x16));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest020)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::T::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::T::Mask.Test(0x17));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest021)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::U::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::U::Mask.Test(0x18));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest022)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::V::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::V::Mask.Test(0x19));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest023)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::W::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::W::Mask.Test(0x1A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest024)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::X::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::X::Mask.Test(0x1B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest025)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Y::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Y::Mask.Test(0x1C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest026)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Z::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Z::Mask.Test(0x1D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest027)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D1::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D1::Mask.Test(0x1E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest028)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D2::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D2::Mask.Test(0x1F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest029)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D3::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D3::Mask.Test(0x20));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest030)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D4::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D4::Mask.Test(0x21));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest031)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D5::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D5::Mask.Test(0x22));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest032)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D6::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D6::Mask.Test(0x23));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest033)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D7::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D7::Mask.Test(0x24));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest034)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D8::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D8::Mask.Test(0x25));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest035)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D9::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D9::Mask.Test(0x26));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest036)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::D0::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::D0::Mask.Test(0x27));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest037)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Return::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Return::Mask.Test(0x28));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest038)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Escape::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Escape::Mask.Test(0x29));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest039)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Backspace::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Backspace::Mask.Test(0x2A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest040)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Tab::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Tab::Mask.Test(0x2B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest041)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Space::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Space::Mask.Test(0x2C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest042)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Minus::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Minus::Mask.Test(0x2D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest043)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Plus::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Plus::Mask.Test(0x2E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest044)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::OpenBracket::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::OpenBracket::Mask.Test(0x2F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest045)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::CloseBracket::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::CloseBracket::Mask.Test(0x30));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest046)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Pipe::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Pipe::Mask.Test(0x31));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest047)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Tilde::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Tilde::Mask.Test(0x32));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest048)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Semicolon::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Semicolon::Mask.Test(0x33));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest049)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Quote::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Quote::Mask.Test(0x34));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest050)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Backquote::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Backquote::Mask.Test(0x35));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest051)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Comma::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Comma::Mask.Test(0x36));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest052)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Period::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Period::Mask.Test(0x37));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest053)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Slash::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Slash::Mask.Test(0x38));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest054)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::CapsLock::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::CapsLock::Mask.Test(0x39));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest055)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F1::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F1::Mask.Test(0x3A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest056)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F2::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F2::Mask.Test(0x3B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest057)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F3::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F3::Mask.Test(0x3C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest058)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F4::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F4::Mask.Test(0x3D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest059)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F5::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F5::Mask.Test(0x3E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest060)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F6::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F6::Mask.Test(0x3F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest061)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F7::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F7::Mask.Test(0x40));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest062)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F8::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F8::Mask.Test(0x41));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest063)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F9::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F9::Mask.Test(0x42));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest064)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F10::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F10::Mask.Test(0x43));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest065)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F11::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F11::Mask.Test(0x44));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest066)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F12::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F12::Mask.Test(0x45));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest067)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::PrintScreen::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::PrintScreen::Mask.Test(0x46));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest068)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::ScrollLock::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::ScrollLock::Mask.Test(0x47));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest069)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Pause::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Pause::Mask.Test(0x48));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest070)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Insert::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Insert::Mask.Test(0x49));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest071)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Home::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Home::Mask.Test(0x4A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest072)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::PageUp::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::PageUp::Mask.Test(0x4B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest073)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Delete::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Delete::Mask.Test(0x4C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest074)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::End::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::End::Mask.Test(0x4D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest075)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::PageDown::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::PageDown::Mask.Test(0x4E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest076)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::RightArrow::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::RightArrow::Mask.Test(0x4F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest077)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::LeftArrow::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::LeftArrow::Mask.Test(0x50));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest078)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::DownArrow::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::DownArrow::Mask.Test(0x51));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest079)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::UpArrow::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::UpArrow::Mask.Test(0x52));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest080)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumLock::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumLock::Mask.Test(0x53));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest081)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadDivide::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadDivide::Mask.Test(0x54));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest082)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadMultiply::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadMultiply::Mask.Test(0x55));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest083)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadSubtract::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadSubtract::Mask.Test(0x56));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest084)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadAdd::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadAdd::Mask.Test(0x57));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest085)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadEnter::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadEnter::Mask.Test(0x58));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest086)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad1::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad1::Mask.Test(0x59));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest087)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad2::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad2::Mask.Test(0x5A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest088)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad3::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad3::Mask.Test(0x5B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest089)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad4::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad4::Mask.Test(0x5C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest090)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad5::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad5::Mask.Test(0x5D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest091)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad6::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad6::Mask.Test(0x5E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest092)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad7::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad7::Mask.Test(0x5F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest093)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad8::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad8::Mask.Test(0x60));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest094)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad9::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad9::Mask.Test(0x61));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest095)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPad0::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPad0::Mask.Test(0x62));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest096)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadDot::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadDot::Mask.Test(0x63));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest097)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Backslash::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Backslash::Mask.Test(0x64));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest098)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Application::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Application::Mask.Test(0x65));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest099)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Power::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Power::Mask.Test(0x66));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest100)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadEquals::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadEquals::Mask.Test(0x67));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest101)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F13::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F13::Mask.Test(0x68));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest102)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F14::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F14::Mask.Test(0x69));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest103)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F15::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F15::Mask.Test(0x6A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest104)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F16::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F16::Mask.Test(0x6B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest105)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F17::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F17::Mask.Test(0x6C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest106)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F18::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F18::Mask.Test(0x6D));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest107)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F19::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F19::Mask.Test(0x6E));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest108)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F20::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F20::Mask.Test(0x6F));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest109)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F21::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F21::Mask.Test(0x70));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest110)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F22::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F22::Mask.Test(0x71));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest111)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F23::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F23::Mask.Test(0x72));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest112)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::F24::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::F24::Mask.Test(0x73));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest113)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadComma::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadComma::Mask.Test(0x85));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest114)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Ro::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Ro::Mask.Test(0x87));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest115)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::KatakanaHiragana::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::KatakanaHiragana::Mask.Test(0x88));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest116)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Yen::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Yen::Mask.Test(0x89));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest117)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Henkan::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Henkan::Mask.Test(0x8A));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest118)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Muhenkan::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Muhenkan::Mask.Test(0x8B));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest119)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::NumPadCommaPc98::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::NumPadCommaPc98::Mask.Test(0x8C));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest120)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::HangulEnglish::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::HangulEnglish::Mask.Test(0x90));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest121)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Hanja::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Hanja::Mask.Test(0x91));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest122)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Katakana::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Katakana::Mask.Test(0x92));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest123)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::Hiragana::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::Hiragana::Mask.Test(0x93));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest124)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::ZenkakuHankaku::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::ZenkakuHankaku::Mask.Test(0x94));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest125)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::LeftControl::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::LeftControl::Mask.Test(0xE0));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest126)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::LeftShift::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::LeftShift::Mask.Test(0xE1));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest127)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::LeftAlt::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::LeftAlt::Mask.Test(0xE2));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest128)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::LeftGui::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::LeftGui::Mask.Test(0xE3));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest129)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::RightControl::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::RightControl::Mask.Test(0xE4));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest130)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::RightShift::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::RightShift::Mask.Test(0xE5));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest131)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::RightAlt::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::RightAlt::Mask.Test(0xE6));
}

TEST(KeyboardKeyMaskSuite, KeyboardKeyMaskTest132)
{
    EXPECT_EQ(
        1, ::nn::hid::KeyboardKey::RightGui::Mask.CountPopulation());

    EXPECT_TRUE(::nn::hid::KeyboardKey::RightGui::Mask.Test(0xE7));
}
