﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>

#include <nn/hid.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>

#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>
#include "../Common/testHid_ConsoleSixAxisSensor.h"

namespace
{

// 最大サイズのバッファを用意しておく
NN_ALIGNAS(0x1000)
static uint8_t s_WorkBuffer[::nn::hid::SevenSixAxisSensorWorkBufferSize];

// TORIAEZU: handle インタフェースが UniquePad に対応するまでの暫定対処
::nn::hid::system::UniqueSixAxisSensorHandle g_Handle = ::nn::hid::system::UniqueSixAxisSensorHandle();

} // namespace

//!< サポートの有無を検証するテスト
TEST(SevenSixAxisSensorCalibrationSuite, IsSupportedTest)
{
    ::nn::hid::InitializeSevenSixAxisSensor(s_WorkBuffer,
                                            ::nn::hid::SevenSixAxisSensorWorkBufferSize);

    EXPECT_EQ(true,
              ::nn::hid::system::IsSixAxisSensorAccurateUserCalibrationSupported(g_Handle));

    ::nn::hid::FinalizeSevenSixAxisSensor();
}

//!< ユーザーキャリブレーションのステージ遷移に関するテスト
TEST(SevenSixAxisSensorCalibrationSuite, BasicTest)
{
    ::nn::hid::InitializeSevenSixAxisSensor(s_WorkBuffer,
                                            ::nn::hid::SevenSixAxisSensorWorkBufferSize);

    // 開始前
    ::nn::hid::system::SixAxisSensorAccurateUserCalibrationState state;
    auto result = ::nn::hid::system::GetSixAxisSensorAccurateUserCalibrationState(&state, g_Handle);
    EXPECT_TRUE(result.IsSuccess());
    EXPECT_LE(state.progress, 1.f);
    EXPECT_GE(state.progress, 0.f);
    EXPECT_EQ(::nn::hid::system::SixAxisSensorAccurateUserCalibrationStage_Completed,
              state.stage);

    // 開始直後
    EXPECT_TRUE(::nn::hid::system::StartSixAxisSensorAccurateUserCalibration(g_Handle).IsSuccess());
    result = ::nn::hid::system::GetSixAxisSensorAccurateUserCalibrationState(&state, g_Handle);
    EXPECT_TRUE(result.IsSuccess());
    EXPECT_LE(state.progress, 1.f);
    EXPECT_GE(state.progress, 0.f);
    EXPECT_TRUE(
        (::nn::hid::system::SixAxisSensorAccurateUserCalibrationStage_InitialStage == state.stage) ||
        (::nn::hid::system::SixAxisSensorAccurateUserCalibrationStage_AtRest == state.stage)
    );

    // Start を複数回呼び出しても問題がないか
    EXPECT_TRUE(::nn::hid::system::StartSixAxisSensorAccurateUserCalibration(g_Handle).IsSuccess());

    // キャンセル処理の呼び出しが可能か
    ::nn::hid::system::CancelSixAxisSensorAccurateUserCalibration(g_Handle);

    // キャンセル後は初期状態に戻っているか
    result = ::nn::hid::system::GetSixAxisSensorAccurateUserCalibrationState(&state, g_Handle);
    EXPECT_TRUE(result.IsSuccess());
    EXPECT_LE(state.progress, 1.f);
    EXPECT_GE(state.progress, 0.f);
    EXPECT_EQ(::nn::hid::system::SixAxisSensorAccurateUserCalibrationStage_Completed,
              state.stage);

    // キャンセルを複数回呼び出しても問題がないか
    ::nn::hid::system::CancelSixAxisSensorAccurateUserCalibration(g_Handle);

    ::nn::hid::FinalizeSevenSixAxisSensor();
}

