﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hdcp/hdcp_Lib.h>

namespace nnt { namespace hdcp {

typedef nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController> HdcpService;

class HdcpTestInitializer
{
private:
    nn::os::SystemEventType m_CecEventType;
    HdcpService m_HdcpService;
public:
    NN_IMPLICIT HdcpTestInitializer() NN_NOEXCEPT;
    ~HdcpTestInitializer() NN_NOEXCEPT;
    HdcpService GetHdcpServiceObject() NN_NOEXCEPT;
};

}}
