# dataset.txt を フィルタするスクリプトです。
# 
# 第1引数＝データセットのサブセット定義ファイルのパス（各行に flytが列挙されたファイル）
# 第2引数＝データセット定義ファイルのパス
# 例：
# $subset_filepath="\Externals\TestBinaries\Ui2d\OldTools\0_12_x\datasubset.txt"
# $dataset_filepath="\Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\dataset.txt"

$subset_filepath=$args[0]
$dataset_filepath=$args[1]

if(!(Test-Path($subset_filepath)))
{
    Write-Error Not Exisit "[" + $subset_filepath + "]"
}else{
    Write-Output "subset_filepath=" $subset_filepath
}

if(!(Test-Path($dataset_filepath)))
{
    Write-Error Not Exisit "[" + $dataset_filepath + "]"
}else{
    Write-Output "dataset_filepath=" $dataset_filepath
}

$subsets=Get-Content -Path $subset_filepath
$validBlocks = @();
Get-Content -Path $dataset_filepath -Delimiter "[" | ForEach-Object -Process {
	  # [ で区切ったブロック毎に、、、
      $block=$_
      # subset リストに含まれているファイルのみ採用します。
      foreach($flyt in $subsets) { 
          $flyt = $flyt.Replace(".flyt",".bflyt");
          if($block.Contains($flyt))
          {
              # 以下のようなブロックを validBlocks に足していく 
              # [ で分割しているので、[ を足して、末端の [ を削除してやる必要がある。
              # [PartsMagnify]
              #     LayoutName  = partsMagnify.bflyt
              #
              $validBlocks += "[" + $block.Trim("[");
          }  
      }
}

# 変更後の内容を書き戻します。
$newContents=($validBlocks -join "")
$newFilePath = [System.IO.Path]::GetDirectoryName($dataset_filepath) + "\dataset.txt" 
Set-Content -Path $newFilePath -Value $newContents