﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/font/font_WideTagProcessor.h>
#include <nn/font/font_Font.h>

namespace nnt {
namespace ui2d {

class CustomTagProcessor : public nn::font::WideTagProcessor
{
    typedef nn::font::WideTagProcessor Base;
public:
    //! 実行時型情報です。
    NN_FONT_RUNTIME_TYPEINFO(CustomTagProcessor::Base);

    CustomTagProcessor(nn::font::Font* pDefaultFont, nn::font::Font* pAlternativeFont)
    {
        m_pDefaultFont = pDefaultFont;
        m_pAlternativeFont = pAlternativeFont;
    }

    virtual CustomTagProcessor::Operation Process(
        uint32_t code,
        nn::font::PrintContext<uint16_t>* pContext) NN_OVERRIDE
    {
        return ProcessTag(code, pContext, NULL);
    }

    virtual nn::font::WideTagProcessor::Operation CalculateRect(
        nn::font::Rectangle* pRect,
        nn::font::PrintContext<uint16_t>* pContext,
        uint32_t code) NN_OVERRIDE
    {
        return ProcessTag(code, pContext, pRect);
    }

private:
    static const uint32_t TagDefaultFont = 0x01;
    static const uint32_t TagAlternativeFont = 0x02;

    nn::font::WideTagProcessor::Operation ProcessTag(
        uint32_t code,
        nn::font::WideTagProcessor::ContextType* pContext,
        nn::font::Rectangle* pRect);

    nn::font::Font* m_pDefaultFont;
    nn::font::Font* m_pAlternativeFont;
};

} // namespace ui2d
} // namespace nnt
