﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{TextureIDManager.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a class that wraps the texture
 *  and sampler registering process. Textures and samplers
 *  must be registered with the device with an ID so that
 *  they can be used by a shader program.
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nvn/nvn.h>
#include <atomic>
#include "MemoryPool.h"

class TextureIDManager
{
public:
    NN_IMPLICIT TextureIDManager(NVNdevice* pDevice);
    ~TextureIDManager();

    int RegisterTexture(NVNtexture* pTexture);
    int RegisterSampler(NVNsampler* pSampler);

    void SetSamplerPool(NVNcommandBuffer* pCommandBuffer);
    void SetTexturePool(NVNcommandBuffer* pCommandBuffer);

private:
    MemoryPool          m_DescriptorPool;
    NVNtexturePool      m_TexturePool;
    NVNsamplerPool      m_SamplerPool;
    NVNdevice*          m_pDevice;
    std::atomic<int>    m_CurrentSamplerID;
    std::atomic<int>    m_CurrentTextureID;

};
