﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

in int gl_VertexID;

out Varying
{
    vec2 texCoord;
    flat int layer;
    flat int miplevel;
} Out;

void main()
{
    float x = (gl_VertexID & 1) * -2.0 + 1.0;
    float y = (gl_VertexID & 2) * -1.0 + 1.0;

    gl_Position = vec4(x,y,.0,1.0);
    Out.texCoord = (vec2(x,y) + vec2(1.0)) * .5;

    int texInfo = (gl_VertexID >> 2);
    int mipLevel = texInfo >> 15;
    int layer = texInfo ^ (mipLevel << 15);

    Out.layer = layer;
    Out.miplevel = mipLevel;
}
