﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "testGfxUtil_Application.h"
#include "gfxUtilGpuBenchmark_Types.h"

struct ApplicationConfiguration
{
    ApplicationMode initialApplicationMode;
    bool exitAfterTest;

    nnt::gfx::util::BenchmarkType interactiveModeInitialBenchmark;
    const char* interactiveModeOutputFile;

    const char* replayModeInputFile;

    FindMaxPowerUpdateMode findMaxPowerUpdateMode;
    const char* findMaxPowerModeOutputFilePath;
    int findMaxPowerModeBenchmarkMask;

    const char* updateTimingsModeInputFile;
    const char* updateTimingsModeOutputFile;
    const char* updateTimingsModeTestCaseFilter;

    void SetDefault();
};


bool ParseCommandLine(int argc, char** argv, ApplicationConfiguration* pApplicationConfiguration);
void PrintCommandLineHelp();

