﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nnt { namespace gfx { namespace util {

template<int _MAX_COUNT>
class PropertyArray
{
    GpuBenchmarkPropertyHolder          m_PropertyArray[_MAX_COUNT];

public:
    static const int                    MaxCount = _MAX_COUNT;

public:
                                        PropertyArray();
                                        ~PropertyArray();

    GpuBenchmarkPropertyHolder*         Get(int index);
    const GpuBenchmarkPropertyHolder*   Get(int index) const;

    int                                 GetCount() const;

    int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const;
    int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize);
    GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName);
};

template<int _MAX_COUNT>
inline PropertyArray<_MAX_COUNT>::PropertyArray()
{
}

template<int _MAX_COUNT>
inline PropertyArray<_MAX_COUNT>::~PropertyArray()
{
}

template<int _MAX_COUNT>
inline GpuBenchmarkPropertyHolder* PropertyArray<_MAX_COUNT>::Get(int index)
{
    NN_ASSERT(index < GetCount());
    return &m_PropertyArray[index];
}

template<int _MAX_COUNT>
inline const GpuBenchmarkPropertyHolder* PropertyArray<_MAX_COUNT>::Get(int index) const
{
    NN_ASSERT(index < GetCount());
    return &m_PropertyArray[index];
}

template<int _MAX_COUNT>
inline int PropertyArray<_MAX_COUNT>::GetCount() const
{
    return _MAX_COUNT;
}


template<int _MAX_COUNT>
int PropertyArray<_MAX_COUNT>::FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const
{
    NN_ASSERT_GREATER_EQUAL(destinationArrayMaxSize, GetCount());
    if (destinationArrayMaxSize < GetCount())
        return 0;

    for (int i = 0; i < _MAX_COUNT; ++i)
    {
        ppDestinationArray[i] = &m_PropertyArray[i];
    }
    return _MAX_COUNT;
}

template<int _MAX_COUNT>
int PropertyArray<_MAX_COUNT>::FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize)
{
    NN_ASSERT_GREATER_EQUAL(destinationArrayMaxSize, GetCount());
    if (destinationArrayMaxSize < GetCount())
        return 0;

    for (int i = 0; i < _MAX_COUNT; ++i)
    {
        ppDestinationArray[i] = &m_PropertyArray[i];
    }
    return _MAX_COUNT;
}

template<int _MAX_COUNT>
GpuBenchmarkPropertyHolder* PropertyArray<_MAX_COUNT>::FindPropertyByName(const char* propertyName)
{
    for (int i = 0; i < _MAX_COUNT; ++i)
    {
        const char* currentPropertyName = m_PropertyArray[i].GetName();
        if (strcmp(currentPropertyName, propertyName) == 0)
        {
            return &m_PropertyArray[i];
        }
    }

    return nullptr;
}

} } } // namespace nnt { namespace gfx { namespace util {
