﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

#include "gfxUtilGpuBenchmark_Property.h"
#include "gfxUtilGpuBenchmark_PropertyArray.h"
#include "gfxUtilGpuBenchmark_ResShader.h"

#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_State.h>

namespace nnt { namespace gfx { namespace util {

class GpuBenchmarkTemplate : public GpuBenchmark
{
public:
    static const char*  ClassName;

    enum Dummy1Value
    {
        Dummy1Value_0,
        Dummy1Value_1
    };

private:
    static const int                    m_RenderSize = 4096;
    static const nn::gfx::ImageFormat   m_RenderFormat = nn::gfx::ImageFormat_R8_G8_B8_A8_Unorm;
    static const nn::gfx::TileMode      m_TileMode = nn::gfx::TileMode_Optimal;

    int                                 m_Dummy0;
    Dummy1Value                         m_Dummy1;

    nn::gfx::Texture                    m_RenderTexture;
    nn::gfx::ColorTargetView            m_RenderTextureColorTargetView;
    nn::gfx::ViewportScissorState       m_ViewportScissorState;

    ResShader                           m_ResShader;
    nn::gfx::Buffer                     m_VertexBuffer;

    nn::gfx::Buffer                     m_OutputCopyBuffer;
    size_t                              m_OutputCopyBufferSize;

    enum Property
    {
        Property_Dummy0 = 0,
        Property_Dummy1,
        Property_Count,
    };

    PropertyArray<Property_Count>       m_PropertyArray;

public:
                                                GpuBenchmarkTemplate();
    virtual                                     ~GpuBenchmarkTemplate();

    virtual void                                Initialize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;
    virtual void                                Finalize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;

    virtual void                                InitializeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;
    virtual void                                FinalizeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;

    int                                         GetDummy0() const;
    void                                        SetDummy0(int value);

    Dummy1Value                                 GetDummy1() const;
    void                                        SetDummy1(Dummy1Value value);

    virtual void                                PreBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;
    virtual void                                DoBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer, int runCount) NN_OVERRIDE;

    virtual void                                PrintResults(nn::TimeSpan gpuTimeElapsed, nn::TimeSpan cpuTimeElapsed, int runCount, nn::gfx::util::DebugFontTextWriter* pDebugFontTextWriter) NN_OVERRIDE;

    virtual void                                CopyResultToBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_OVERRIDE;
    virtual void                                MapResultBuffer(void** pOutBuffer, size_t* pOutBufferSize) NN_OVERRIDE;
    virtual void                                UnmapResultBuffer() NN_OVERRIDE;

    virtual const char*                         GetName() const NN_OVERRIDE;
    virtual BenchmarkType                       GetType() const NN_OVERRIDE;
    virtual int                                 GetPropertyCount() const NN_OVERRIDE;
    virtual int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const NN_OVERRIDE;
    virtual int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         GetPropertyByIndex(int index) NN_OVERRIDE;

};

inline int GpuBenchmarkTemplate::GetDummy0() const
{
    return m_Dummy0;
}
inline void GpuBenchmarkTemplate::SetDummy0(int value)
{
    m_Dummy0 = value;
}

inline GpuBenchmarkTemplate::Dummy1Value GpuBenchmarkTemplate::GetDummy1() const
{
    return m_Dummy1;
}
inline void GpuBenchmarkTemplate::SetDummy1(Dummy1Value value)
{
    m_Dummy1 = value;
}

} } } // namespace nnt { namespace gfx { namespace util {
