﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT Varying
{
    vec2 texCoord;
} InOut;

#if VERTEX_SHADER

layout(location = 0) in vec3 i_Position;
layout(location = 1) in vec2 i_TexCoord;

void main()
{
    gl_Position = vec4(i_Position, 1.0f);
    InOut.texCoord = i_TexCoord;
}

#endif

#if PIXEL_SHADER

layout(location = 0) out vec4 o_ColorMrt0;
#if PS_MRT_COUNT > 1
layout(location = 1) out vec4 o_ColorMrt1;
#endif
#if PS_MRT_COUNT > 2
layout(location = 2) out vec4 o_ColorMrt2;
#endif
#if PS_MRT_COUNT > 3
layout(location = 3) out vec4 o_ColorMrt3;
#endif

void main()
{
    o_ColorMrt0 = vec4(InOut.texCoord.xxy, 1);
#if PS_MRT_COUNT > 1
    o_ColorMrt1 = vec4(InOut.texCoord.xyx, 1);
#endif
#if PS_MRT_COUNT > 2
    o_ColorMrt2 = vec4(InOut.texCoord.yxx, 1);
#endif
#if PS_MRT_COUNT > 3
    o_ColorMrt3 = vec4(InOut.texCoord.yxy, 1);
#endif
}

#endif
