﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


INOUT Varying
{
#if BLIT_TEXTURE
    vec2 texCoord;
#else
    vec4 color;
#endif
} InOut;

#if VERTEX_SHADER

in int gl_VertexID;

void main()
{
    float posX = float(gl_VertexID & 0x01);
    float posY = float((gl_VertexID & 0x02) >> 1);

    float colorIntensity = float(gl_VertexID >> 3) / 15.0f;

    float clipSpaceX = (posX * 2.0) - 1.0;
    float clipSpaceY = 1.0 - (posY * 2.0);

    vec4 position = vec4(clipSpaceX, clipSpaceY, 0.5, 1.0);

    gl_Position = position;
#if BLIT_TEXTURE
    InOut.texCoord = vec2(posX, posY);
#else
    InOut.color = vec4(posX * colorIntensity, posY * colorIntensity, 1.0f * colorIntensity, 1.0f);
    //InOut.color = vec4(1.0, 1.0, 1.0, 1.0);

#endif
}
#endif

#if PIXEL_SHADER

#if BLIT_TEXTURE
layout(binding = 0) uniform sampler2D tex;
#endif

layout(location = 0) out vec4 o_Color;

void main()
{
#if BLIT_TEXTURE
    o_Color = texture(tex, InOut.texCoord);
#else
    o_Color = InOut.color;
#endif
}

#endif
