﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/os/os_TickTypes.h>
#include <nn/nn_TimeSpan.h>

namespace nnt { namespace gfx { namespace util { namespace agingtest {


class FrameRateTracker
{
private:
    int                 m_FrameCounter;
    nn::os::Tick        m_PreviousFrameTick;

    int64_t             m_MaxTimeSpan;
    int64_t             m_MinTimeSpan;
    int64_t             m_AverageTimeSpan;

    static const size_t m_HistoryLength = 64;
    int64_t             m_FrameTimeSpanHistory[m_HistoryLength];

public:
                        FrameRateTracker();
                        ~FrameRateTracker();

    void                Initialize();
    void                Finalize();

    void                UpdateFps();
    void                GetFps(float* pOutMinFps, float* pOutMaxFps, float* pOutAverageFps);

private:
    int64_t             ComputeAverageDurationTickFromHistory();
};

} } } } // namespace nnt { namespace gfx { namespace util { namespace agingtest {
