﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>

#include <gfx/demo.h>

#include "textureHandle.h"

// Texture.
static const char* const SNOWFLAKE_TEX = "textures/gpuParticle/snow_flake";
static const char* const SAKURA_TEX = "textures/gpuParticle/sakura";
static const char* const MIST_TEX = "textures/gpuParticle/mist";

DEMOGfxTexture g_SnowTex;
DEMOGfxTexture g_SakuraTex;
DEMOGfxTexture g_MistTex;

// Initialize texture.
void InitTexture()
{
    {
        bool res = g_SnowTex.Initialize( SNOWFLAKE_TEX );
        ASSERT(res && "Unable to load texture file");
        NN_UNUSED( res );
    }

    {
        bool res = g_SakuraTex.Initialize( SAKURA_TEX );
        ASSERT(res && "Unable to load texture file");
        NN_UNUSED( res );
    }

    {
        bool res = g_MistTex.Initialize( MIST_TEX );
        ASSERT(res && "Unable to load texture file");
        NN_UNUSED( res );
    }
}

// Terminate texture.
void TermTexture()
{
    // Free textures.
    g_SnowTex.Finalize();
    g_SakuraTex.Finalize();
    g_MistTex.Finalize();
}
