﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <gfx/demo.h>

#include "particle.h"

const u32 MAX_PARTICLE = 0x10000;
u32 currentParticleNum = MAX_PARTICLE / 4;

f32 currentLoop = 0.0f;
f32 loopLength = 65535.0f;

void InitParticle()
{
    currentParticleNum = MAX_PARTICLE / 4;
    currentLoop = 0.0f;
    loopLength = 65535.0f;
}

u32 AddParticle(s32 adder)
{
    s32 num = currentParticleNum;
    num += adder;
    if (num > static_cast< s32 >(MAX_PARTICLE))
        currentParticleNum = MAX_PARTICLE;
    else if (num < 1)
        currentParticleNum = 1;
    else
        currentParticleNum = num;
    return currentParticleNum;
}

void UpdateParticle(f32 frameTime)
{
    currentLoop += frameTime;
    while (currentLoop > loopLength)
        currentLoop -= loopLength;
}
