﻿// NOLINT(style/copyright)
/*
 * Copyright 2014-2016 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO USER:
 *
 * This source code is subject to NVIDIA ownership rights under U.S. and
 * international Copyright laws.
 *
 * This software and the information contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and conditions
 * of a form of NVIDIA software license agreement.
 *
 * NVIDIA MAKES NO REPRESENTATION ABOUT THE SUITABILITY OF THIS SOURCE
 * CODE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY OF ANY KIND.  NVIDIA DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOURCE CODE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL,
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS,  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION,  ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOURCE CODE.
 *
 * U.S. Government End Users.   This source code is a "commercial item" as
 * that term is defined at  48 C.F.R. 2.101 (OCT 1995), consisting  of
 * "commercial computer  software"  and "commercial computer software
 * documentation" as such terms are  used in 48 C.F.R. 12.212 (SEPT 1995)
 * and is provided to the U.S. Government only as a commercial end item.
 * Consistent with 48 C.F.R.12.212 and 48 C.F.R. 227.7202-1 through
 * 227.7202-4 (JUNE 1995), all U.S. Government End Users acquire the
 * source code with only those rights set forth herein.
 *
 * Any use of this source code in individual and commercial software must
 * include, in the user documentation and internal comments to the code,
 * the above Disclaimer and U.S. Government End Users Notice.
 */

#pragma once

#include <nvperfapi.h>
#include <string>

namespace NvPerfApiSamples
{
    namespace Profiler
    {
        /** Initialize the perfworks library
        *
        * \param[in] APILoadFn   Pointer to one of the NVPA_LoadDriverAPI() functions.
        * \param[in] verbosity   Enable printing info to stdout, 0=off.
        */
        bool Init(NVPA_Status (*APILoadFn)(), uint8_t verbosity=0);

        struct MetricSpec
        {
            std::string name;
            bool serialized;
        };
        /** Create a perfworks configuration.
        *
        * A perfworks configuration contains the metrics to be enabled for a context and device.
        *
        * \param[in] deviceIndex    The context to create the configuration for.
        * \param[in] activityKind   The configuration's activity-kind.
        * \param[in] first          Pointer to the first MetricSpec in a list of MetricSpecs to be enabled for this configuration.
        * \param[in] last           Pointer to the last MetricSpec in a list of MetricSPecs to be enabled for this configuration.
        * \param[in] verbosity      Enable printing info to stdout, 0=off.
        */
        NVPA_Config* CreateConfig(size_t deviceIndex, NVPA_ActivityKind activityKind, MetricSpec const* first, MetricSpec const* last, uint8_t verbosity = 0);


        enum class MetricDataStatus
        {
            Failed,
            NotReady,
            Ready
        };

        /** Collect metric values and print to stdout.
        *
        * \param[in] pStackData     Pointer to the StackData in which metrics were collected.
        */
        std::string CollectAndPrint(const NVPA_StackData* pStackData);
    }
}
