﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

namespace G3dTest{

    // @brief テスト用のアロケータです。
    class ViewerTestAllocator
    {
    public:
        ViewerTestAllocator();

        //! @brief メモリを確保します。
        void* Allocate(size_t size, size_t alignment);

        //! @brief メモリを解放します。
        void Free(void* pBufferData);

        static void* AllocateWithUserData(size_t size, size_t alignment, void* pUserData);
        static void FreeWithUserData(void* ptr, void* pUserData);

        //! @brief HtcsHelper に渡すためのメモリ確保関数
        static void* Allocate(size_t size);

        //! @brief HtcsHelper に渡すためのメモリ解放関数
        static void Deallocate(void* ptr, size_t size);

    private:
        // バッファ用のクラスです。
        class Buffer;

        Buffer* EraseBuffer(void* pBufferData);
        std::vector<Buffer*> m_Buffers;
    };
}
