﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/gfx.h>

struct CharModelCreateArgBase
{
    const char* pCharInfoPath;
    const char* pTexPath;
    const char* pShapePath;
    const char* pBfresPath;
    struct CharModelParameter
    {
        int texResolution;
        nn::gfx::ImageFormat texFormat;
        int texMipCount;
        int expressionFlags;
        int createFlags;
    } charModelParameter;
};

class CharModelCreateArg : protected CharModelCreateArgBase
{
public:
    CharModelCreateArg() : CharModelCreateArgBase()
    {
    }

    ~CharModelCreateArg()
    {
    }

    void SetCharInfoPath( const char* pPath )
    {
        this->pCharInfoPath = pPath;
    }
    void SetTexPath( const char* pPath )
    {
        this->pTexPath = pPath;
    }
    void SetShapePath( const char* pPath )
    {
        this->pShapePath = pPath;
    }
    void SetBfresPath( const char* pPath )
    {
        this->pBfresPath = pPath;
    }

    void SetTexResolution( int resolution )
    {
        this->charModelParameter.texResolution = resolution;
    }
    void SetTexFormat( nn::gfx::ImageFormat format )
    {
        this->charModelParameter.texFormat = format;
    }
    void SetTexMipCount( int count )
    {
        this->charModelParameter.texMipCount = count;
    }
    void SetExpressionFlags( int flags )
    {
        this->charModelParameter.expressionFlags = flags;
    }
    void SetCreateFlags( int flags )
    {
        this->charModelParameter.createFlags = flags;
    }

    const char* GetCharInfoPath() const
    {
        return this->pCharInfoPath;
    }
    const char* GetTexPath() const
    {
        return this->pTexPath;
    }
    const char* GetShapePath() const
    {
        return this->pShapePath;
    }
    const char* GetBfresPath() const
    {
        return this->pBfresPath;
    }

    int GetTexResolution() const
    {
        return this->charModelParameter.texResolution;
    }
    nn::gfx::ImageFormat GetTexFormat() const
    {
        return this->charModelParameter.texFormat;
    }
    int GetTexMipCount() const
    {
        return this->charModelParameter.texMipCount;
    }
    int GetExpressionFlags() const
    {
        return this->charModelParameter.expressionFlags;
    }
    int GetCreateFlags() const
    {
        return this->charModelParameter.createFlags;
    }
};
