﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/vfx/vfx_System.h>


class HandlingCommand;


//------------------------------------------------------------------------------
//! @brief  テストセット
//------------------------------------------------------------------------------
class HandlingTestSet
{
public:
    //------------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //------------------------------------------------------------------------------
    HandlingTestSet();

    //------------------------------------------------------------------------------
    //! @brief  デストラクタです。
    //------------------------------------------------------------------------------
    ~HandlingTestSet();

    //------------------------------------------------------------------------------
    //! @brief  エフェクトシステム設定します。
    //!
    //! @param[in] pSystem エフェクトシステム
    //------------------------------------------------------------------------------
    void SetEffectSystem( nn::vfx::System* pSystem );

    //------------------------------------------------------------------------------
    //! @brief  エフェクトシステムを取得します。
    //!
    //! @return エフェクトシステムを返します。
    //------------------------------------------------------------------------------
    nn::vfx::System* GetEffectSystem();

    //------------------------------------------------------------------------------
    //! @brief  エフェクト操作ハンドルを設定します。
    //!
    //! @param[in] pHandle エフェクト操作ハンドル
    //------------------------------------------------------------------------------
    void SetEsetHandle( nn::vfx::Handle* pHandle );

    //------------------------------------------------------------------------------
    //! @brief  エフェクト操作ハンドルを取得します。
    //!
    //! @return エフェクト操作ハンドルを返します。
    //------------------------------------------------------------------------------
    nn::vfx::Handle* GetEsetHandle();

    //------------------------------------------------------------------------------
    //! @brief  キャプチャーフレームを設定します。
    //!
    //! @param[in] pFrames   キャプチャーフレーム
    //! @param[in] numFrames キャプチャーフレーム数
    //------------------------------------------------------------------------------
    void SetCaptureFrames( int* pFrames );

    //------------------------------------------------------------------------------
    //! @brief  キャプチャーフレームを取得します。
    //!
    //! @return キャプチャーフレームを返します。
    //------------------------------------------------------------------------------
    const int* GetCaptureFrames() const;

    //------------------------------------------------------------------------------
    //! @brief  操作コマンドを追加します。
    //!         ここで追加したコマンドはデストラクタで自動的に破棄されます。
    //!
    //! @param[in] pCommand 操作コマンド
    //! @param[in] debug    コマンドデバッグのOn/Off
    //------------------------------------------------------------------------------
    void AddCommand( HandlingCommand* pCommand, bool debug = false );

    //------------------------------------------------------------------------------
    //! @brief  フレーム番号を設定します。
    //!
    //! @param[in] frameNum フレーム番号
    //------------------------------------------------------------------------------
    void SetFrameNum( int frameNum );

    //------------------------------------------------------------------------------
    //! @brief  フレーム番号を取得します。
    //!
    //! @return フレーム番号を返します。
    //------------------------------------------------------------------------------
    int GetFrameNum() const;

    //------------------------------------------------------------------------------
    //! @brief  操作コマンドを実行します。
    //!
    //! @param[in] pCommand 操作コマンド
    //------------------------------------------------------------------------------
    void ExecuteCommands();

    //------------------------------------------------------------------------------
    //! @brief  キャプチャーを行うかどうか取得します。
    //!
    //! @return キャプチャーを行うときtrueを返します。
    //------------------------------------------------------------------------------
    bool DoCapture() const;

    //------------------------------------------------------------------------------
    //! @brief  テストが終わったかどうか取得します。
    //!
    //! @return テストが終わったときtrueを返します。
    //------------------------------------------------------------------------------
    bool IsEnd() const;

private:
    nn::vfx::System*              m_pEffectSystem;      //!< エフェクトシステム
    nn::vfx::Handle*              m_pEsetHandle;        //!< エフェクト操作ハンドル

    int*                          m_pCaptureFrames;     //!< キャプチャーフレーム
    std::vector<HandlingCommand*> m_commands;           //!< 操作コマンド
    std::vector<bool>             m_commandDebug;       //!< コマンド実行前のブレークOn/Off

    int                           m_frameNum;           //!< フレーム番号
    int                           m_commandIndex;       //!< 操作コマンドインデックス
};

