﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testGraphics_ProgramOptions.h"

#include <cstdlib>
#include <cstring>
#include <cctype>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

namespace nnt{ namespace graphics{

    static ProgramOptions g_ProgramOptionInstance = {};

    const ProgramOptions* ProgramOptions::GetInstancePointer()
    {
        return &g_ProgramOptionInstance;
    }

    static bool ToBoolean(const char* str)
    {
        char buffer[10];
        std::strncpy(buffer, str, sizeof(buffer));
        for(char* p = buffer; *p != '\0'; ++p)
        {
            *p = static_cast<char>(std::toupper(*p));
        }
        if(std::strcmp(str, "1") == 0
            || std::strcmp(str, "TRUE") == 0
            || std::strcmp(str, "YES") == 0
            || std::strcmp(str, "ENABLE") == 0
            || std::strcmp(str, "ENABLED") == 0
            )
        {
            return true;
        }
        return false;
    }

    void ProgramOptions::Parse(int argc, char** argv)
    {
        ProgramOptions* pOptions = &g_ProgramOptionInstance;

        for(int i = 1; i < argc; i++)
        {
            const char* arg = argv[i];
            if(std::strcmp(arg, "--captured-image-directory") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->capturedImageDirectoryPath = Path(argv[i + 1]).Normalize();
                i += 1;
            }
            else if(std::strcmp(arg, "--reference-image-directory") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->referenceImageDirectoryPath = Path(argv[i + 1]).Normalize();
                i += 1;
            }
            else if(std::strcmp(arg, "--result-root-path") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->resultRootPath = Path(argv[i + 1]).Normalize();
                i += 1;
            }
            else if(std::strcmp(arg, "--color-tolerance") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->colorTolerance = atoi(argv[i + 1]);
                i += 1;
            }
            else if(std::strcmp(arg, "--displacement-tolerance") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->displacementTolerance = atoi(argv[i + 1]);
                i += 1;
            }
            else if(std::strcmp(arg, "--different-area-tolerance") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->differentAreaTolerance = atoi(argv[i + 1]);
                i += 1;
            }
            else if(std::strcmp(arg, "--ignore-captured-image-not-exists") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->ignoreCapturedImageNotExits = ToBoolean(argv[i + 1]);
                i += 1;
            }
            else if (std::strcmp(arg, "--ignore-comparison-result") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->ignoreComparisonResult = ToBoolean(argv[i + 1]);
                i += 1;
            }
            else if (std::strcmp(arg, "--save-actual-image-difference") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->saveActualImageDifference = ToBoolean(argv[i + 1]);
                i += 1;
            }
            else
            {
                NN_LOG("unknown option: %s\n", arg);
            }
        }
    }
}}
