﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nnt{ namespace graphics{

    struct Allocator
    {
    public:
        void* pArgument;
        void* (*allocateFunction)(size_t size, int alignment, void* pArgument);
        void (*freeFunction)(void* ptr, void* pArgument);

    public:
        void* Allocate(size_t size, int alignment) const
        {
            return allocateFunction(size, alignment, pArgument);
        }
        void Free(void* ptr) const
        {
            freeFunction(ptr, pArgument);
        }
        template<typename T>
        T* AllocateTypedArray(int count) const
        {
            return reinterpret_cast<T*>(
                Allocate(static_cast<size_t>(sizeof(T) * count), NN_ALIGNOF(T))
            );
        }
        template<typename T>
        void FreeTypedArray(T* ptr) const
        {
            Free(ptr);
        }
    };

}}
