﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>

#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
#include <nnc/nn_DeviceCode.h>
#endif

#include <nnc/gpio/gpio.h>
#include <nnc/gpio/gpio_PadAccessorDev.h>

#include <nnc/nn_Log.h>

#include <stdint.h>
#include <stdbool.h>

#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
const nnDeviceCode TestGpioPadNameIn = { 0ul };
const nnDeviceCode TestGpioPadNameOut = { 0ul };
#else // gen1
// TORIAEZU:ボードごとの開放端子をここで切り替え
#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
    const int TestGpioPad1 = 160;
    const int TestGpioPad2 = 161;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
    const int TestGpioPad1 = 80;
    const int TestGpioPad2 = 81;
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected or supported
#endif

#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)
    const nngpioGpioPadName TestGpioPadName = nngpioGpioPadName_AudioPowerEnable;
#elif defined(NN_BUILD_CONFIG_SPEC_NX)
    const nngpioGpioPadName TestGpioPadName = nngpioGpioPadName_CodecLdoEnTemp;
#else
    #error NN_BUILD_CONFIG_SPEC_ not selected or supported
#endif
#endif

// このテストではひとまず各 API を呼ぶだけで、内容が正しいかどうかはチェックしません。
bool nntgpioCallAllGpioCInterfaces(void)
{
    // セッション用の構造体
    nngpioGpioPadSession test1Session;
    nngpioGpioPadSession test2Session;

    nngpioDirection        direction;
    nngpioInterruptMode    mode;
    bool                   gpioBool;
    nngpioInterruptStatus  status;
    nnResult               result;
    nnosSystemEventType    event;
    nngpioGpioValue        value;

    NNC_LOG("%s: StartTest\n", __FUNCTION__);

    nngpioInitialize();

    NNC_LOG("%s: Initialize Done\n", __FUNCTION__);

#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
    if ( !nnDeviceCodeIsEqual(TestGpioPadNameIn, nnDeviceCodeMakeInvalidCode()) )
    {
        result = nngpioOpenSession2(&test1Session, TestGpioPadNameIn);
        NNC_LOG("%s: OpenSession2 = %d\n", __FUNCTION__, result);
        if ( nnResultIsFailure(result) )
        {
            return false;
        }
#else // gen1
    {
        nngpioOpenSessionForDev(&test1Session, TestGpioPad1);
#endif
        nngpioSetDirection(&test1Session, nngpioDirection_Input);
        direction = nngpioGetDirection(&test1Session);

        NNC_LOG("%s: SetDirection = %d\n", __FUNCTION__, direction);

        nngpioSetInterruptMode(&test1Session, nngpioInterruptMode_AnyEdge);
        mode = nngpioGetInterruptMode(&test1Session);

        NNC_LOG("%s: SetInterruptMode = %d\n", __FUNCTION__, mode);

        nngpioSetInterruptEnable(&test1Session, true);
        gpioBool = nngpioGetInterruptEnable(&test1Session);

        NNC_LOG("%s: SetInterruptEnable = %d\n", __FUNCTION__, gpioBool);

        status = nngpioGetInterruptStatus(&test1Session);

        NNC_LOG("%s: GetInterruptStatus = %d\n", __FUNCTION__, status);

        nngpioClearInterruptStatus(&test1Session);

        value = nngpioGetValue(&test1Session);

        NNC_LOG("%s: GetValue = %d\n", __FUNCTION__, value);

        result = nngpioBindInterrupt(&event, &test1Session);

        NNC_LOG("%s: BindInterrupt = %d\n", __FUNCTION__, result);

        nngpioUnbindInterrupt(&test1Session);

        nngpioCloseSession(&test1Session);
    }

    // 出力関連
#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
    if ( !nnDeviceCodeIsEqual(TestGpioPadNameOut, nnDeviceCodeMakeInvalidCode()) )
    {
        result = nngpioOpenSession2(&test2Session, TestGpioPadNameOut);
        NNC_LOG("%s: OpenSession2 = %d\n", __FUNCTION__, result);
        if ( nnResultIsFailure(result) )
        {
            return false;
        }
#else // gen1
    {
        nngpioOpenSessionForDev(&test2Session, TestGpioPad2);
#endif

        nngpioSetDirection(&test2Session, nngpioDirection_Output);
        direction = nngpioGetDirection(&test2Session);

        NNC_LOG("%s: SetDirection = %d\n", __FUNCTION__, direction);

        nngpioSetValue(&test2Session, nngpioGpioValue_Low);

        nngpioCloseSession(&test2Session);
    }

    // OpenSession のチェック
#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
    // 相当の API なし
#else // gen1
    nngpioGpioPadSession audioPowerSession;
    nngpioOpenSession(&audioPowerSession, TestGpioPadName);
    nngpioCloseSession(&audioPowerSession);
#endif

    nngpioFinalize();

    return true;
}

