﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gc/detail/gc_AsicOperation.h>

#include "testGc_Unit_GcLibrary_Util.h"

using namespace nn::gc;
using namespace nn::gc::detail;

TEST(GcUnitTest, AsicOperationTest)
{
    NN_LOG("\nInfo: Asic Operation Buffer Test\n");
    char zero[GcMmcCmd60DataSize];
    memset(zero, 0, sizeof(zero));

    NN_LOG("\nInfo: Asic Operation Card Command Buffer Test\n");
    {
        AsicOperationCardCommandBuffer aocc;
        TESTOUT(aocc.bufferMap.operationId == AsicOperationIndex_CARD_CMDOUT, "same index (struct map)");

        // 構造体は正しいか？
        aocc.bufferMap.dataPageSize = 0x22;
        aocc.bufferMap.dataDirection = 1;
        aocc.bufferMap.reserved1 = 9;
        aocc.bufferMap.dataPageNum = UINT32_MAX;
        for(int i=0; i<16; i++)
        {
            aocc.bufferMap.commandBuffer[i] = (u8)i;
        }
        for(int i=0; i<8; i++)
        {
            aocc.bufferMap.reserved2[i] = (u8)(2 * i);
        }
        for(int i=0; i<32; i++)
        {
            aocc.bufferMap.cv[i] = (u8)(4 * i);
        }

        char ans_array[] = {
            0x10, 0x22, 0x01, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
            0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00, 0x02, 0x04, 0x06, 0x08, 0x0A, 0x0C, 0x0E,
            0x00, 0x04, 0x08, 0x0C, 0x10, 0x14, 0x18, 0x1C, 0x20, 0x24, 0x28, 0x2C, 0x30, 0x34, 0x38, 0x3C,
            0x40, 0x44, 0x48, 0x4C, 0x50, 0x54, 0x58, 0x5C, 0x60, 0x64, 0x68, 0x6C, 0x70, 0x74, 0x78, 0x7C
        };

        TESTCMP(reinterpret_cast<char*>(&aocc.bufferMap), ans_array, sizeof(ans_array), "expected buffer");
    }

    // TODO:
    //{
    //    // SetReadCommand, SetWriteCommand のテスト
    //    AsicOperationCardCommandBuffer aocc;
    //    aocc.SetReadCommand(0x12345678, 0x98765432);
    //    char ans[] = {
    //        CardCommandId_secureReadPage, 0x12, 0x34, 0x56, 0x78, 0x76, 0x54, 0x32
    //    };
    //    TESTCMP(aocc.bufferMap.commandBuffer, ans, sizeof(ans), "expected read command");
    //    PrintArray(aocc.bufferMap.commandBuffer, sizeof(aocc.bufferMap.commandBuffer));
    //    PrintArray(ans, sizeof(ans));

    //    aocc.SetWriteCommand(0x12345678, 0x98765432);
    //    ans[0] = CardCommandId_secureWritePage;
    //    TESTCMP(aocc.bufferMap.commandBuffer, ans, sizeof(ans), "expected write command");
    //    PrintArray(aocc.bufferMap.commandBuffer, sizeof(aocc.bufferMap.commandBuffer));
    //    PrintArray(ans, sizeof(ans));
    //}
}
