﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Directory.h>

class SdFileAccessor
{
private:
    SdFileAccessor();
    bool m_IsSdInserted;

public:
    static SdFileAccessor &GetInstance()
    {
        static SdFileAccessor sdFileAccessor;
        return sdFileAccessor;
    }
    nn::Result Read(char* outBuffer, size_t* outReadLength, const size_t bufferLength, const char* filePath);
    nn::Result Write(const char* buffer, const size_t bufferLength, const char* filePath);

    void GetDirectoryList(nn::fs::DirectoryEntry* outDirectoryEntryBuffer, int64_t* outDirectoryEntryCount, const size_t directoryEntryBufferLength, const char* directoryPath)
    {
        GetDirectoryOrFileList(outDirectoryEntryBuffer, outDirectoryEntryCount, directoryEntryBufferLength, directoryPath, nn::fs::OpenDirectoryMode_Directory);
    }
    void GetFileList(nn::fs::DirectoryEntry* outDirectoryEntryBuffer, int64_t* outDirectoryEntryCount, const size_t directoryEntryBufferLength, const char* directoryPath)
    {
        GetDirectoryOrFileList(outDirectoryEntryBuffer, outDirectoryEntryCount, directoryEntryBufferLength, directoryPath, nn::fs::OpenDirectoryMode_File);
    }
    bool IsDirectoryExisted(nn::fs::DirectoryEntry* workDirectoryEntryBuffer, const size_t directoryEntryBufferLength, const char* directoryPath, const char* targetName)
    {
        return IsEntryExisted(workDirectoryEntryBuffer, directoryEntryBufferLength, directoryPath, targetName, nn::fs::OpenDirectoryMode_Directory);
    }
    bool IsFileExisted(nn::fs::DirectoryEntry* workDirectoryEntryBuffer, const size_t directoryEntryBufferLength, const char* directoryPath, const char* targetName)
    {
        return IsEntryExisted(workDirectoryEntryBuffer, directoryEntryBufferLength, directoryPath, targetName, nn::fs::OpenDirectoryMode_File);
    }
    bool IsSdInserted()
    {
        return m_IsSdInserted;
    }

private:
    void GetDirectoryOrFileList(nn::fs::DirectoryEntry* outDirectoryEntryBuffer, int64_t* outDirectoryEntryCount, const size_t directoryEntryBufferLength, const char* directoryPath, int openDirectoryMode);
    bool IsEntryExisted(nn::fs::DirectoryEntry* workDirectoryEntryBuffer, const size_t directoryEntryBufferLength, const char* directoryPath, const char* targetName, int openDirectoryMode);
};

