﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nn/fs/fs_SdCardPrivate.h>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>

namespace {

TEST(CacheStorage, CreateAndEnumerateManyHeavy)
{
    static const int CreateCount = 512;
    static const int64_t DataSize = 64 * 1024;
    static const int64_t JournalSize = 64 * 1024;

    nnt::fs::util::DeleteAllTestSaveData();

    NN_UTIL_SCOPE_EXIT
    {
        nnt::fs::util::DeleteAllTestSaveData();
    };

    for( int i = 0; i < CreateCount; ++i )
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateCacheStorage(i, DataSize, JournalSize));
        if( (i % 7) == 0 )
        {
            NN_LOG("%d/%d\n", i + 1, CreateCount);
        }
    }

    nn::fs::CacheStorageListHandle handle;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::OpenCacheStorageList(&handle));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::CloseCacheStorageList(handle);
    };

    static nn::fs::CacheStorageInfo info[CreateCount];
    int count;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::ReadCacheStorageList(&count, info, handle, CreateCount));
    EXPECT_EQ(CreateCount, count);

    for( int i = 0; i < CreateCount; ++i )
    {
        EXPECT_EQ(i, info[i].index);
    }
}

}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();
    nn::fs::SetEnabledAutoAbort(false);

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}

