﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn.h>
#include <nn/fs.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataManagementPrivate.h>
#include <nn/fs/fs_SaveDataTypes.h>

class StressTestParam
{
public:
    static const uint64_t OwnerIds[2];

    static const nn::ncm::ApplicationId ApplicationIds[2];
    static const nn::fs::UserId UserIds[2];

    static const auto SaveDataSize = 16 * 1024 * 1024;
    static const auto JournalSize = 16 * 1024 * 1024;

    static const int LoopCount = 5;
    static const int ThreadCount = 8;
    static const int ThreadCountMax = 8;
    static const auto ThreadStackSize = 16 * 1024;
};

