﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_TestContext.h"

class StressTestMountRomFs : public StressTestMountInfoBase
{
public:
    StressTestMountRomFs() NN_NOEXCEPT
    {
    }

    virtual ~StressTestMountRomFs() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    //! マウント
    void Mount() NN_NOEXCEPT
    {
        size_t cacheSize = 0;
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&cacheSize));
        m_CacheBuffer.reset(new char[cacheSize]);
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountRom(GetMountName(), m_CacheBuffer.get(), cacheSize));
    }

    //! アンマウント
    void Unmount() NN_NOEXCEPT
    {
        nn::fs::Unmount(GetMountName());
    }

    //! リードオンリーかどうかを取得
    virtual bool IsReadOnly() const NN_NOEXCEPT NN_OVERRIDE
    {
        return true;
    }

private:
    std::unique_ptr<char[]> m_CacheBuffer;
};
