﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsUtil/testFs_util.h>
#include "testFs_Stress_OpenEntriesTestCase.h"

namespace nnt { namespace fs {

class RenameFilesTestCase : public OpenEntriesTestCase
{
public:
    RenameFilesTestCase(int threadCount, int fileCount) NN_NOEXCEPT
        : OpenEntriesTestCase(threadCount, fileCount, nn::fs::DirectoryEntryType_File)
    {
    }

    virtual ~RenameFilesTestCase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual int GetLoopCount() const NN_NOEXCEPT NN_OVERRIDE
    {
        return 50;
    }

    virtual void Test(FsStressTest* pTest, int threadIndex) NN_NOEXCEPT NN_OVERRIDE
    {
        Fail(threadIndex);

        ASSERT_FALSE(pTest->IsReadOnly(GetTestCaseIndex()));
        for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
        {
            char path[PathLength];
            char renamedPath[PathLength];
            MakePath(path, GetEntryIndex(threadIndex, entryIndex));
            nn::util::SNPrintf(renamedPath, sizeof(renamedPath), "%s_renamed", path);
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::RenameFile(path, renamedPath));
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::RenameFile(renamedPath, path));
        }

        Fail(threadIndex);
    }
};

class RenameFiles : public RenameFilesTestCase
{
public:
    RenameFiles() NN_NOEXCEPT
        : RenameFilesTestCase(FsStressTest::ThreadCountMax, 10)
    {
    }
};

class RenameFewerFiles : public RenameFilesTestCase
{
public:
    RenameFewerFiles() NN_NOEXCEPT
        : RenameFilesTestCase(FsStressTest::ThreadCountMax / 2, 10)
    {
    }
};

TEST_F(SaveDataFsStressTest, RenameFiles)
{
    Test<RenameFiles>(GetMountName());
}

TEST_F(MultipleSaveDataFsStressTest, RenameFiles)
{
    Test<RenameFewerFiles, RenameFewerFiles>(GetMountName(0), GetMountName(1));
}

TEST_F(OtherApplicationSaveDataFsStressTest, RenameFiles)
{
    Test<RenameFiles>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)
TEST_F(HostFsStressTest, RenameFiles)
{
    Test<RenameFiles>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)

TEST_F(SdCardFsStressTest, RenameFiles)
{
    Test<RenameFiles>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)
TEST_F(TemporaryStorageFsStressTest, RenameFiles)
{
    Test<RenameFiles>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)

}}
