﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFs_Stress_AccessFilesTestCase.h"

namespace nnt { namespace fs {

class EnsureSaveData : public FsStressTest::TestCase
{
public:
    virtual ~EnsureSaveData() NN_NOEXCEPT NN_OVERRIDE {}

    virtual int GetLoopCount() const NN_NOEXCEPT NN_OVERRIDE
    {
        return 2000;
    }

    virtual void Test(FsStressTest*, int threadIndex) NN_NOEXCEPT NN_OVERRIDE
    {
        Fail(threadIndex);
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::EnsureSaveData(nn::account::InvalidUid));
        Succeed(threadIndex);
    }
};

TEST_F(FsStressTest, EnsureSaveData)
{
    Test<EnsureSaveData>(nullptr);
}

}}
