﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFs_Stress_OpenEntriesTestCase.h"

namespace nnt { namespace fs {

class CreateFilesTestCase : public OpenEntriesTestCase
{
public:
    CreateFilesTestCase(int threadCount, int fileCount) NN_NOEXCEPT
        : OpenEntriesTestCase(threadCount, fileCount, nn::fs::DirectoryEntryType_File)
    {
    }

    virtual ~CreateFilesTestCase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Test(FsStressTest* pTest, int threadIndex) NN_NOEXCEPT NN_OVERRIDE
    {
        ASSERT_FALSE(pTest->IsReadOnly(GetTestCaseIndex()));
        Fail(threadIndex);
        for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
        {
            char path[PathLength];
            MakePath(path, GetEntryIndex(threadIndex, entryIndex));
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::DeleteFile(path));
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::CreateFile(path, 0));
        }
        Succeed(threadIndex);
    }
};

class CreateFiles : public CreateFilesTestCase
{
public:
    CreateFiles() NN_NOEXCEPT
        : CreateFilesTestCase(FsStressTest::ThreadCountMax, 10)
    {
    }
};

class CreateFewerFiles : public CreateFilesTestCase
{
public:
    CreateFewerFiles() NN_NOEXCEPT
        : CreateFilesTestCase(FsStressTest::ThreadCountMax / 2, 10)
    {
    }
};

TEST_F(SaveDataFsStressTest, CreateFiles)
{
    Test<CreateFiles>(GetMountName());
}

TEST_F(MultipleSaveDataFsStressTest, CreateFiles)
{
    Test<CreateFewerFiles, CreateFewerFiles>(GetMountName(0), GetMountName(1));
}

TEST_F(OtherApplicationSaveDataFsStressTest, CreateFiles)
{
    Test<CreateFiles>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)
TEST_F(HostFsStressTest, CreateFiles)
{
    Test<CreateFiles>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)

TEST_F(SdCardFsStressTest, CreateFiles)
{
    Test<CreateFiles>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)
TEST_F(TemporaryStorageFsStressTest, CreateFiles)
{
    Test<CreateFiles>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)

}}
