﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_StressTest.h"

namespace nnt { namespace fs {

class AccessDeepDirectoriesTestCase : public FsStressTest::TestCase
{
public:
    static const auto PathLength = 512;

public:
    AccessDeepDirectoriesTestCase(int threadCount, int depthMax) NN_NOEXCEPT;
    virtual ~AccessDeepDirectoriesTestCase() NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetThreadCount() const NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetUp(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TearDown(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;

protected:
    template<size_t Length>
    const char* MakePath(char (&path)[Length], int entryIndex, int entryDepth) const NN_NOEXCEPT
    {
        return MakePath(path, Length, entryIndex, entryDepth);
    }

    const char* MakePath(
        char* path,
        size_t length,
        int entryIndex,
        int entryDepth) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_GREATER_EQUAL(entryIndex, 0);
        NN_SDK_REQUIRES_GREATER_EQUAL(entryDepth, 0);
        auto currentLength = nn::util::SNPrintf(
            path,
            length,
            "%s:%s/dir%d",
            GetMountName(),
            GetTestDirectoryPath(),
            entryIndex + 100);
        for( auto depth = 1; depth <= entryDepth; ++depth )
        {
            currentLength += nn::util::SNPrintf(
                path + currentLength,
                length - currentLength,
                "/%d",
                depth);
        }
        return path;
    }

    int GetDepthMax() const NN_NOEXCEPT
    {
        return m_DepthMax;
    }

    void CreateDirectories(
        char* buffer,
        size_t bufferLength,
        int entryIndex) NN_NOEXCEPT;

private:
    int m_ThreadCount;
    int m_DepthMax;
};

}}
